/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.up.web;

import io.vertx.core.json.JsonObject;
import io.vertx.up.func.Fn;
import io.vertx.up.log.Annal;
import io.vertx.up.tool.mirror.Instance;
import io.vertx.zero.log.internal.Log4JAnnal;
import io.vertx.zero.marshal.options.Opts;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public final class ZeroAmbient {
    private static final String KEY = "inject";
    private static final Annal LOGGER = new Log4JAnnal(ZeroAmbient.class);
    private static final ConcurrentMap<String, Class<?>> INJECTIONS;
    private static final Opts<JsonObject> OPTS;

    public static Class<?> getPlugin(String key) {
        return (Class)INJECTIONS.get(key);
    }

    public static ConcurrentMap<String, Class<?>> getInjections() {
        return INJECTIONS;
    }

    static void init() {
    }

    private ZeroAmbient() {
    }

    static {
        OPTS = Opts.get();
        INJECTIONS = new ConcurrentHashMap();
        Fn.flingUp(() -> {
            JsonObject opt = OPTS.ingest(KEY);
            Fn.itJObject(opt, (item, field) -> {
                String plugin = item.toString();
                LOGGER.info("[ ZERO ] The raw data ( node = {0} ) has been detected plugin ( {1} = {2} )", KEY, field, plugin);
                INJECTIONS.put((String)field, Instance.clazz(plugin));
            });
        }, LOGGER);
    }
}

