/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.zero.atom;

import io.reactivex.Observable;
import io.vertx.core.json.JsonObject;
import io.vertx.up.func.Fn;
import io.vertx.up.log.Annal;
import io.vertx.up.tool.Jackson;
import io.vertx.up.tool.io.IO;
import io.vertx.zero.atom.Mojo;
import io.vertx.zero.atom.Pool;
import java.text.MessageFormat;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Function;

public class Mirror {
    private static final String POJO = "pojo/{0}.yml";
    private final transient Annal logger;
    private transient Mojo mojo;
    private transient JsonObject data = new JsonObject();
    private final transient JsonObject converted = new JsonObject();

    public static Mirror create(Class<?> clazz) {
        return new Mirror(clazz);
    }

    private Mirror(Class<?> clazz) {
        this.logger = Annal.get(clazz);
    }

    public Mirror mount(String filename) {
        this.mojo = Fn.pool(Pool.MOJOS, filename, () -> {
            JsonObject data = (JsonObject)IO.getYaml(MessageFormat.format(POJO, filename));
            return Fn.get(() -> Jackson.deserialize(data, Mojo.class), data);
        });
        return this;
    }

    public Mirror connect(JsonObject data) {
        this.data = Fn.get(new JsonObject(), () -> ((JsonObject)data).copy(), data);
        return this;
    }

    public Mirror to() {
        this.convert(this.mojo.getMapper());
        return this;
    }

    public Mojo mojo() {
        return this.mojo;
    }

    private void convert(ConcurrentMap<String, String> mapper) {
        Observable.fromIterable((Iterable)this.data.fieldNames()).groupBy(mapper::containsKey).map(contain -> (Boolean)contain.getKey() != false ? contain.subscribe(from -> {
            String to = (String)mapper.get(from);
            this.converted.put(to, this.data.getValue(from));
        }) : contain.subscribe(item -> this.converted.put(item, this.data.getValue(item)))).subscribe();
    }

    public Mirror from() {
        this.convert(this.mojo.getRevert());
        return this;
    }

    public Mirror apply(Function<String, String> function) {
        JsonObject result = this.data.copy();
        result.forEach(entry -> this.converted.put((String)function.apply((String)entry.getKey()), entry.getValue()));
        return this;
    }

    public JsonObject json(Object entity, boolean overwrite) {
        JsonObject data = (JsonObject)Jackson.serializeJson(entity);
        JsonObject merged = this.converted.copy();
        for (String field : data.fieldNames()) {
            if (overwrite) {
                merged.put(field, data.getValue(field));
                continue;
            }
            if (merged.containsKey(field)) continue;
            merged.put(field, data.getValue(field));
        }
        return merged;
    }

    public <T> T get() {
        Object reference = Jackson.deserialize(this.converted, this.mojo.getType());
        return (T)Fn.get(null, () -> reference, new Object[]{reference});
    }

    public JsonObject result() {
        return this.converted;
    }
}

