/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.zero.atom;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.ClassDeserializer;
import com.fasterxml.jackson.databind.ClassSerializer;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import io.vertx.up.func.Fn;
import io.vertx.up.log.Annal;
import java.io.Serializable;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class Mojo
implements Serializable {
    private static final Annal LOGGER = Annal.get(Mojo.class);
    private static final String TYPE = "type";
    private static final String MAPPING = "mapping";
    private static final String COLUMNS = "columns";
    @JsonProperty(value="type")
    @JsonSerialize(using=ClassSerializer.class)
    @JsonDeserialize(using=ClassDeserializer.class)
    private Class<?> type;
    @JsonProperty(value="mapping")
    private ConcurrentMap<String, String> config = new ConcurrentHashMap<String, String>();
    @JsonProperty(value="columns")
    private ConcurrentMap<String, String> columns = new ConcurrentHashMap<String, String>();

    public Class<?> getType() {
        return this.type;
    }

    public void setType(Class<?> type) {
        this.type = type;
    }

    public ConcurrentMap<String, String> getMapper() {
        Fn.safeSemi(null == this.config, LOGGER, () -> {
            this.config = new ConcurrentHashMap<String, String>();
        });
        return this.config;
    }

    public ConcurrentMap<String, String> getRevert() {
        Fn.safeSemi(this.config.keySet().size() != this.config.values().size(), LOGGER, () -> LOGGER.warn("[V] Warning for duplicated mapper size: keys = {0}, values = {1}", this.config.keySet().size(), this.config.values().size()));
        ConcurrentHashMap<String, String> mapper = new ConcurrentHashMap<String, String>();
        this.config.forEach((key, value) -> mapper.put((String)value, (String)key));
        return mapper;
    }

    public ConcurrentMap<String, String> getColumns() {
        Fn.safeSemi(null == this.columns, LOGGER, () -> {
            this.columns = new ConcurrentHashMap<String, String>();
        });
        return this.columns;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Mojo)) {
            return false;
        }
        Mojo mojo = (Mojo)o;
        return Objects.equals(this.type, mojo.type);
    }

    public int hashCode() {
        return Objects.hash(this.type);
    }
}

