/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.zero.log;

import io.vertx.core.json.JsonObject;
import io.vertx.up.func.Fn;
import io.vertx.zero.exception.heart.ErrorMissingException;
import io.vertx.zero.marshal.node.Node;
import java.text.MessageFormat;

public final class Errors {
    public static String normalize(Class<?> clazz, int code, Object ... args) {
        return Errors.normalize(clazz, code, "[ERR{0}] ({1}) ZeroException occus: {2}.", args);
    }

    public static String normalizeWeb(Class<?> clazz, int code, Object ... args) {
        return Errors.normalize(clazz, code, "[ERR{0}] ({1}) Web Exception occus: {2}.", args);
    }

    private static String normalize(Class<?> clazz, int code, String tpl, Object ... args) {
        return Fn.getJvm(() -> {
            String key = ("E" + Math.abs(code)).intern();
            Node<JsonObject> node = Node.infix("error");
            JsonObject data = node.read();
            if (null != data && data.containsKey(key)) {
                String pattern = data.getString(key);
                String error = MessageFormat.format(pattern, args);
                return MessageFormat.format(tpl, String.valueOf(code), clazz.getSimpleName(), error);
            }
            throw new ErrorMissingException(code, clazz.getName());
        }, clazz);
    }

    public static String method(Class<?> clazzPos, String methodPos) {
        StackTraceElement[] methods = Thread.currentThread().getStackTrace();
        String methodName = null;
        int position = 0;
        for (int idx = 0; idx < methods.length; ++idx) {
            String clazz = methods[idx].getClassName();
            String method = methods[idx].getMethodName();
            if (!clazz.equals(clazzPos.getName()) || !method.equals(methodPos)) continue;
            position = idx + 1;
        }
        if (position < methods.length - 1) {
            methodName = methods[position].getMethodName();
        }
        return methodName;
    }
}

