/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.tp.feign;

import feign.Feign;
import feign.Request;
import feign.Retryer;
import feign.codec.Decoder;
import feign.codec.Encoder;
import feign.codec.ErrorDecoder;
import feign.codec.JsonObjectDecoder;
import feign.codec.JsonObjectEncoder;
import io.vertx.core.json.JsonObject;
import io.vertx.tp.init.TpConfig;
import io.zero.epic.fn.Fn;
import java.io.Serializable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class FeignDepot
implements Serializable {
    private static final ConcurrentMap<String, FeignDepot> CACHE = new ConcurrentHashMap<String, FeignDepot>();
    private static final JsonObject DEFAULTS = new JsonObject();
    private static final JsonObject OPTIONS = new JsonObject();
    private final transient TpConfig reference;
    private transient Request.Options options;
    private transient Retryer.Default defaults;

    private FeignDepot(String key, String rule) {
        this.reference = TpConfig.create(key, rule);
        this.initOpts(this.reference.getConfig());
    }

    public static FeignDepot create(String key, String rule) {
        return (FeignDepot)Fn.pool(CACHE, (Object)key, () -> new FeignDepot(key, rule));
    }

    public <T> T build(Class<T> clazz) {
        return this.build(clazz, this.reference.getEndPoint(), null);
    }

    public <T> T build(Class<T> clazz, String endpoint) {
        return this.build(clazz, endpoint, null);
    }

    public <T> T build(Class<T> clazz, String endpoint, ErrorDecoder decoder) {
        Feign.Builder builder = Feign.builder();
        if (null != this.options) {
            builder.options(this.options);
        }
        if (null != this.defaults) {
            builder.retryer((Retryer)this.defaults);
        }
        builder.encoder((Encoder)new JsonObjectEncoder());
        builder.decoder((Decoder)new JsonObjectDecoder());
        if (null != decoder) {
            builder.errorDecoder(decoder);
        }
        return (T)builder.target(clazz, endpoint);
    }

    public String getEndpoint() {
        return this.reference.getEndPoint();
    }

    public JsonObject getConfig() {
        return this.reference.getConfig();
    }

    private void initOpts(JsonObject raw) {
        JsonObject normalized = OPTIONS;
        if (raw.containsKey("timeout")) {
            JsonObject options = raw.getJsonObject("timeout");
            normalized = normalized.mergeIn(options);
        }
        this.options = new Request.Options(normalized.getInteger("connect").intValue(), normalized.getInteger("read").intValue());
        normalized = DEFAULTS;
        if (raw.containsKey("retry")) {
            JsonObject defaults = raw.getJsonObject("retry");
            normalized = normalized.mergeIn(defaults);
        }
        this.defaults = new Retryer.Default((long)normalized.getInteger("period").intValue(), (long)normalized.getInteger("maxPeriod").intValue(), normalized.getInteger("attempts").intValue());
    }

    static {
        if (DEFAULTS.isEmpty()) {
            DEFAULTS.put("period", Integer.valueOf(5000));
            DEFAULTS.put("maxPeriod", Integer.valueOf(5000));
            DEFAULTS.put("attempts", Integer.valueOf(3));
        }
        if (OPTIONS.isEmpty()) {
            OPTIONS.put("connect", Integer.valueOf(1000));
            OPTIONS.put("read", Integer.valueOf(3500));
        }
    }
}

