/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.tp.hikari.config;

import com.zaxxer.hikari.HikariConfig;
import com.zaxxer.hikari.HikariDataSource;
import com.zaxxer.hikari.pool.HikariPool;
import io.vertx.core.json.JsonObject;
import io.vertx.tp.error.DataSourceException;

public class HikariCpConfig {
    private final transient HikariPool pool;

    private HikariCpConfig(JsonObject config) {
        HikariConfig hikariConfig = new HikariConfig();
        hikariConfig.setDriverClassName(config.getString("driverClassName"));
        hikariConfig.setJdbcUrl(config.getString("jdbcUrl"));
        hikariConfig.setUsername(config.getString("username"));
        hikariConfig.setPassword(config.getString("password"));
        hikariConfig.setCatalog(config.getString("catalog"));
        try {
            HikariDataSource dataSource = new HikariDataSource(hikariConfig);
            this.pool = new HikariPool((HikariConfig)dataSource);
        }
        catch (HikariPool.PoolInitializationException ex) {
            throw new DataSourceException(this.getClass(), ex, hikariConfig.getJdbcUrl());
        }
    }

    public static HikariCpConfig create(JsonObject config) {
        return new HikariCpConfig(config);
    }

    public HikariPool getPool() {
        return this.pool;
    }
}

