/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.tp.init;

import io.vertx.core.json.JsonObject;
import io.vertx.up.log.Annal;
import io.vertx.zero.atom.Ruler;
import io.vertx.zero.exception.DynamicConfigTypeException;
import io.vertx.zero.exception.DynamicKeyMissingException;
import io.vertx.zero.marshal.node.Node;
import io.zero.epic.fn.Fn;
import java.io.Serializable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class TpConfig
implements Serializable {
    private static final Annal LOGGER = Annal.get(TpConfig.class);
    private static final ConcurrentMap<String, TpConfig> CACHE = new ConcurrentHashMap<String, TpConfig>();
    private static final Node<JsonObject> TP = Node.infix((String)"tp");
    private static final String KEY_ENDPOINT = "endpoint";
    private static final String KEY_CONFIG = "config";
    private final transient JsonObject config;
    private final transient String endpoint;

    public TpConfig(String key, String rule) {
        JsonObject config = (JsonObject)TP.read();
        Fn.outUp((null == config || !config.containsKey(key) ? 1 : 0) != 0, (Annal)LOGGER, DynamicKeyMissingException.class, (Object[])new Object[]{this.getClass(), key, config});
        Class<?> type = config.getValue(key).getClass();
        Fn.outUp((JsonObject.class != type ? 1 : 0) != 0, (Annal)LOGGER, DynamicConfigTypeException.class, (Object[])new Object[]{this.getClass(), key, type});
        JsonObject raw = config.getJsonObject(key);
        this.endpoint = (String)Fn.getNull(null, () -> raw.getString(KEY_ENDPOINT), (Object[])new Object[]{raw.getValue(KEY_ENDPOINT)});
        this.config = (JsonObject)Fn.getNull((Object)new JsonObject(), () -> raw.getJsonObject(KEY_CONFIG), (Object[])new Object[]{raw.getValue(KEY_CONFIG)});
        if (null != rule) {
            Fn.outUp(() -> Fn.shuntZero(() -> Ruler.verify((String)rule, (JsonObject)this.config), (Object[])new Object[]{this.config}), (Annal)LOGGER);
        }
    }

    public static TpConfig create(String key) {
        return (TpConfig)Fn.pool(CACHE, (Object)key, () -> new TpConfig(key, null));
    }

    public static TpConfig create(String key, String rule) {
        return (TpConfig)Fn.pool(CACHE, (Object)key, () -> new TpConfig(key, rule));
    }

    public JsonObject getConfig() {
        return this.config;
    }

    public String getEndPoint() {
        return this.endpoint;
    }
}

