/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.tp.hikari;

import io.vertx.core.json.JsonObject;
import io.vertx.tp.hikari.config.HikariCpConfig;
import io.vertx.up.func.Fn;
import io.vertx.up.log.Annal;
import io.vertx.up.tool.mirror.Instance;
import io.vertx.zero.atom.Ruler;
import io.vertx.zero.marshal.node.Node;
import io.vertx.zero.marshal.node.ZeroUniform;
import java.sql.Connection;

public class HikariCpPool {
    private static final Annal LOGGER = Annal.get(HikariCpPool.class);
    private static final Node<JsonObject> NODE = (Node)Instance.singleton(ZeroUniform.class, (Object[])new Object[0]);
    private static HikariCpConfig CONFIG;
    private static final String KEY = "pool";
    private static final String HIKARI_KEY = "hikari";

    public static Connection getConnection(JsonObject config) {
        return (Connection)Fn.getJvm(() -> HikariCpConfig.create(config).getPool().getConnection(), (Object[])new Object[]{config});
    }

    public static Connection getConnection() {
        return (Connection)Fn.getJvm(() -> CONFIG.getPool().getConnection(), (Object[])new Object[]{CONFIG});
    }

    static {
        JsonObject config = (JsonObject)NODE.read();
        Fn.safeSemi((null != config && config.containsKey(KEY) ? 1 : 0) != 0, (Annal)LOGGER, () -> {
            JsonObject hitted = config.getJsonObject(KEY);
            Fn.safeSemi((null != hitted && hitted.containsKey(HIKARI_KEY) ? 1 : 0) != 0, (Annal)LOGGER, () -> {
                JsonObject meta = hitted.getJsonObject(HIKARI_KEY);
                Fn.flingUp(() -> Fn.shuntZero(() -> Ruler.verify((String)HIKARI_KEY, (JsonObject)meta), (Object[])new Object[]{meta}), (Annal)LOGGER);
                CONFIG = HikariCpConfig.create(meta);
            });
        });
    }
}

