/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.tp.hikari.config;

import com.zaxxer.hikari.HikariConfig;
import com.zaxxer.hikari.HikariDataSource;
import com.zaxxer.hikari.pool.HikariPool;
import io.vertx.core.json.JsonObject;

public class HikariCpConfig {
    private final transient HikariPool pool;

    public static HikariCpConfig create(JsonObject config) {
        return new HikariCpConfig(config);
    }

    private HikariCpConfig(JsonObject config) {
        HikariConfig hikariConfig = new HikariConfig();
        hikariConfig.setDriverClassName(config.getString("driverClassName"));
        hikariConfig.setJdbcUrl(config.getString("jdbcUrl"));
        hikariConfig.setUsername(config.getString("username"));
        hikariConfig.setPassword(config.getString("password"));
        hikariConfig.setCatalog(config.getString("catalog"));
        HikariDataSource dataSource = new HikariDataSource(hikariConfig);
        this.pool = new HikariPool((HikariConfig)dataSource);
    }

    public HikariPool getPool() {
        return this.pool;
    }
}

