/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.tp.ipc.marshal;

import io.vertx.core.ServidorOptions;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.tp.ipc.marshal.RpcServerStrada;
import io.vertx.up.eon.em.ServerType;
import io.vertx.up.func.Fn;
import io.vertx.up.log.Annal;
import io.vertx.up.tool.Ensurer;
import io.vertx.up.tool.mirror.Instance;
import io.vertx.zero.atom.Ruler;
import io.vertx.zero.config.ServerVisitor;
import io.vertx.zero.exception.ZeroException;
import io.vertx.zero.exception.demon.ServerConfigException;
import io.vertx.zero.marshal.Transformer;
import io.vertx.zero.marshal.node.Node;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class RpcServerVisitor
implements ServerVisitor<ServidorOptions> {
    private static final Annal LOGGER = Annal.get(RpcServerVisitor.class);
    private final transient Node<JsonObject> node = Node.infix((String)"server");
    private final transient Transformer<ServidorOptions> transformer = (Transformer)Instance.singleton(RpcServerStrada.class, (Object[])new Object[0]);

    public ConcurrentMap<Integer, ServidorOptions> visit(String ... key) throws ZeroException {
        Ensurer.eqLength(this.getClass(), (int)0, (Object[])key);
        JsonObject data = (JsonObject)this.node.read();
        Fn.flingZero((null == data || !data.containsKey("server") ? 1 : 0) != 0, (Annal)LOGGER, ServerConfigException.class, (Object[])new Object[]{this.getClass(), null == data ? null : data.encode()});
        return this.visit(data.getJsonArray("server"));
    }

    private ConcurrentMap<Integer, ServidorOptions> visit(JsonArray serverData) throws ZeroException {
        LOGGER.info("[ ZERO ] The raw data ( node = {0}, type = {1} ) before validation is {2}.", new Object[]{"server", ServerType.IPC, serverData.encode()});
        Ruler.verify((String)"server", (JsonArray)serverData);
        ConcurrentHashMap<Integer, ServidorOptions> map = new ConcurrentHashMap<Integer, ServidorOptions>();
        Fn.itJArray((JsonArray)serverData, JsonObject.class, (item, index) -> {
            if (this.isServer((JsonObject)item)) {
                int port = this.extractPort(item.getJsonObject("config"));
                ServidorOptions options = (ServidorOptions)this.transformer.transform(item);
                Fn.safeNull(() -> map.put(port, options), (Object[])new Object[]{port, options});
            }
        });
        LOGGER.info("[ ZERO ] ( node = {0}, type = {1} ) filtered configuration port set = {2}.", new Object[]{"server", ServerType.IPC, map.keySet()});
        return map;
    }

    private int extractPort(JsonObject config) {
        if (null != config) {
            return config.getInteger("port", ServidorOptions.DEFAULT_PORT);
        }
        return ServidorOptions.DEFAULT_PORT;
    }

    private boolean isServer(JsonObject item) {
        return ServerType.IPC.match(item.getString("type"));
    }
}

