/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.tp.plugin.jooq;

import io.vertx.core.Vertx;
import io.vertx.tp.hikari.HikariCpPool;
import io.vertx.up.annotations.Plugin;
import io.vertx.up.func.Fn;
import io.vertx.up.plugin.Infix;
import io.vertx.up.tool.mirror.Instance;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.jooq.Configuration;
import org.jooq.ConnectionProvider;
import org.jooq.SQLDialect;
import org.jooq.impl.DefaultConfiguration;
import org.jooq.impl.DefaultConnectionProvider;

@Plugin
public class JooqInfix
implements Infix {
    private static final String NAME = "ZERO_JOOQ_POOL";
    private static final ConcurrentMap<String, Configuration> CONFIGS = new ConcurrentHashMap<String, Configuration>();
    private static Vertx vertxRef;

    private static void initInternal(Vertx vertx, String name) {
        vertxRef = vertx;
        Fn.pool(CONFIGS, (Object)name, () -> Infix.init("jooq", config -> {
            DefaultConfiguration configuration = new DefaultConfiguration();
            configuration.set(SQLDialect.MYSQL_8_0);
            DefaultConnectionProvider provider = new DefaultConnectionProvider(HikariCpPool.getConnection(config.getJsonObject("provider")));
            configuration.set((ConnectionProvider)provider);
            return configuration;
        }, JooqInfix.class));
    }

    public static void init(Vertx vertx) {
        JooqInfix.initInternal(vertx, NAME);
    }

    public Configuration get() {
        return (Configuration)CONFIGS.get(NAME);
    }

    public static <T> T getDao(Class<T> clazz) {
        Object dao = Instance.instance(clazz, (Object[])new Object[]{CONFIGS.get(NAME)});
        Instance.invoke((Object)dao, (String)"setVertx", (Object[])new Object[]{vertxRef});
        return (T)dao;
    }
}

