package cn.vonce.sql.spring.enumerate;

/**
 * @author Jovi
 * @email imjovi@qq.com
 * @date 2022/12/14 14:47
 */
public enum DbPropagation {

    /**
     * 如果当前没有事务，就新建一个事务，如果已经存在一个事务中，加入到这个事务中。
     */
    REQUIRED,

    /**
     * 表示当前方法不需要事务上下文，但是如果存在当前事务的话，那么这个方法会在这个事务中运行。
     */
    SUPPORTS,

    /**
     * 表示该方法必须在事务中运行，如果当前事务不存在，则会抛出一个异常。不会主动开启一个事务。
     */
    MANDATORY,

    /**
     * 表示当前方法必须运行在它自己的事务中。一个新的事务将被启动，如果存在当前事务，在该方法执行期间，当前事务会被挂起（如果一个事务已经存在，则先将这个存在的事务挂起）。
     */
    REQUIRES_NEW,

    /**
     * 表示该方法不应该运行在事务中，如果存在当前事务，在该方法运行期间，当前事务将被挂起。
     */
    NOT_SUPPORTED,

    /**
     * 表示当前方法不应该运行在事务上下文中，如果当前正有一个事务在运行，则会抛出异常。
     */
    NEVER,

    /**
     * 表示如果当前已经存在一个事务，那么该方法将会在嵌套事务中运行。嵌套的事务可以独立于当前事务进行单独地提交或回滚。如果当前事务不存在，那么其行为与REQUIRED一样。嵌套事务一个非常重要的概念就是内层事务依赖于外层事务。外层事务失败时，会回滚内层事务所做的动作。而内层事务操作失败并不会引起外层事务的回滚。
     */
    NESTED;

}
