/*
 * Decompiled with CFR 0.152.
 */
package cn.vorbote.message.sender.aliyun;

import cn.vorbote.core.exceptions.NotImplementedException;
import cn.vorbote.message.config.AliyunRegion;
import cn.vorbote.message.model.BatchMessageRequest;
import cn.vorbote.message.model.MessageRequest;
import cn.vorbote.message.model.MessageResponse;
import cn.vorbote.message.sender.IMessageSender;
import cn.vorbote.message.util.JacksonSerializer;
import com.aliyuncs.AcsRequest;
import com.aliyuncs.DefaultAcsClient;
import com.aliyuncs.IAcsClient;
import com.aliyuncs.dysmsapi.model.v20170525.SendSmsRequest;
import com.aliyuncs.dysmsapi.model.v20170525.SendSmsResponse;
import com.aliyuncs.exceptions.ClientException;
import com.aliyuncs.profile.DefaultProfile;
import com.aliyuncs.profile.IClientProfile;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class AliyunSender
implements IMessageSender<Map<String, Object>> {
    private static final Logger log = LoggerFactory.getLogger(AliyunSender.class);
    private final String sign;
    private final IAcsClient client;
    private final JacksonSerializer jacksonSerializer;

    public AliyunSender(AliyunRegion region, String sign, String keyId, String keySecret) {
        this(region, sign, keyId, keySecret, new ObjectMapper());
    }

    public AliyunSender(AliyunRegion region, String sign, String keyId, String keySecret, ObjectMapper objectMapper) {
        this.sign = sign;
        this.client = new DefaultAcsClient((IClientProfile)DefaultProfile.getProfile((String)region.getRegionId(), (String)keyId, (String)keySecret));
        this.jacksonSerializer = JacksonSerializer.getJacksonSerializer((ObjectMapper)objectMapper);
    }

    public MessageResponse send(MessageRequest<Map<String, Object>> request) throws JsonProcessingException {
        SendSmsRequest platformRequest = new SendSmsRequest();
        platformRequest.setSignName(this.sign);
        platformRequest.setTemplateCode(request.templateId());
        platformRequest.setPhoneNumbers(request.receiver());
        platformRequest.setTemplateParam(this.jacksonSerializer.serialize(request.params()));
        MessageResponse response = null;
        try {
            SendSmsResponse platformResponse = (SendSmsResponse)this.client.getAcsResponse((AcsRequest)platformRequest);
            response = MessageResponse.initResponse((String)platformResponse.getCode(), (String)platformResponse.getMessage());
            log.info(this.jacksonSerializer.serialize((Object)response));
        }
        catch (ClientException e) {
            log.error(e.getErrMsg());
        }
        return response;
    }

    @Deprecated
    public MessageResponse batchSend(BatchMessageRequest<Map<String, Object>> request) {
        throw new NotImplementedException("This feature will not be implemented as the AliCloud Platform Send SMS interface supports the transmission of single or multiple SMS recipients.");
    }
}

