/*
 * Decompiled with CFR 0.152.
 */
package cn.wanghaomiao.seimi.httpd;

import cn.wanghaomiao.seimi.core.SeimiQueue;
import cn.wanghaomiao.seimi.httpd.HttpRequestProcessor;
import cn.wanghaomiao.seimi.struct.Request;
import cn.wanghaomiao.seimi.utils.StructValidator;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.HashMap;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PushRequestHttpProcessor
extends HttpRequestProcessor {
    private static final String HTTP_API_REQ_DATA_PARAM_KEY = "req";
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    public PushRequestHttpProcessor(SeimiQueue seimiQueue, String crawlerName) {
        super(seimiQueue, crawlerName);
    }

    @Override
    public void handleHttpRequest(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        response.setContentType("application/json; charset=utf-8");
        String seimiReq = request.getParameter(HTTP_API_REQ_DATA_PARAM_KEY);
        HashMap<String, String> body = new HashMap<String, String>();
        int processCount = 0;
        try {
            Object json = JSON.parse((String)seimiReq);
            if (JSONArray.class.equals(json.getClass())) {
                JSONArray ja = (JSONArray)json;
                for (int i = 0; i < ja.size(); ++i) {
                    Request srq = (Request)ja.getObject(i, Request.class);
                    this.pushRequest(srq);
                }
                processCount = ja.size();
            } else if (JSONObject.class.equals(json.getClass())) {
                Request srq = (Request)JSON.parseObject((String)seimiReq, Request.class);
                this.pushRequest(srq);
                processCount = 1;
            }
            body.put("msg", "ok");
            body.put("total", String.valueOf(processCount));
            body.put("code", "0");
        }
        catch (Exception e) {
            this.logger.error("parse Seimi request error,receive data={}", (Object)seimiReq, (Object)e);
            body.put("msg", "err:" + e.getMessage());
            body.put("code", "1");
        }
        PrintWriter out = response.getWriter();
        out.println(JSON.toJSONString(body));
    }

    private void pushRequest(Request seimiRequest) {
        seimiRequest.setCrawlerName(this.crawlerName);
        if (StructValidator.validateAnno(seimiRequest)) {
            this.seimiQueue.push(seimiRequest);
            this.logger.info("Receive an request from http api,request={}", (Object)JSON.toJSONString((Object)seimiRequest));
        } else {
            this.logger.warn("SeimiRequest={} is illegal", (Object)JSON.toJSONString((Object)seimiRequest));
        }
    }
}

