/*
 * Decompiled with CFR 0.152.
 */
package cn.weforward.common;

import cn.weforward.common.KvPair;
import java.util.List;
import java.util.Map;

public interface Dictionary<K, V> {
    public static final Dictionary<?, ?> _Empty = new Dictionary<Object, Object>(){

        @Override
        public Object get(Object key) {
            return null;
        }

        public String toString() {
            return "<empty>";
        }
    };

    public V get(K var1);

    public static class ByArray<K, V>
    implements Dictionary<K, V> {
        KvPair<K, V>[] items;

        public ByArray(KvPair<K, V>[] items) {
            this.items = items;
        }

        @Override
        public V get(K key) {
            int i = this.items.length - 1;
            while (i >= 0) {
                KvPair<K, V> kv = this.items[i];
                if (key.equals(kv.getKey())) {
                    return kv.getValue();
                }
                --i;
            }
            return null;
        }
    }

    public static final class Util {
        public static <K, V> Dictionary<K, V> empty() {
            return _Empty;
        }

        public static <K, V> Dictionary<K, V> valueOf(Map<K, V> map) {
            if (map == null) {
                throw new NullPointerException("map is <null>");
            }
            return new WrapMap<K, V>(map);
        }

        public static <K, V> Dictionary<K, V> valueOf(KvPair<K, V>[] items) {
            if (items == null || items.length == 0) {
                return Util.empty();
            }
            return new ByArray<K, V>(items);
        }

        public static <K, V> Dictionary<K, V> valueOf(List<KvPair<K, V>> list) {
            if (list == null || list.size() == 0) {
                return Util.empty();
            }
            return new ByArray((KvPair[])list.toArray());
        }
    }

    public static class WrapMap<K, V>
    implements Dictionary<K, V> {
        Map<K, V> map;

        public WrapMap(Map<K, V> map) {
            this.map = map;
        }

        @Override
        public V get(K key) {
            return this.map.get(key);
        }
    }
}

