/*
 * Decompiled with CFR 0.152.
 */
package cn.weforward.common;

import cn.weforward.common.execption.OverquotaException;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.atomic.AtomicInteger;

public interface Quotas {
    public static final Quotas _NoLimit = new Quotas(){
        protected final AtomicInteger m_Count = new AtomicInteger(0);

        @Override
        public int getMax() {
            return Integer.MAX_VALUE;
        }

        @Override
        public int getCount() {
            return this.m_Count.get();
        }

        @Override
        public int getQuota(Governable resource, int concurrent) {
            return Integer.MAX_VALUE;
        }

        @Override
        public int use(Governable resource, int concurrent) throws OverquotaException {
            return this.m_Count.incrementAndGet();
        }

        @Override
        public int refund(Object resource) {
            return this.m_Count.decrementAndGet();
        }

        public String toString() {
            return "{nolimit:" + this.m_Count.get() + "}";
        }
    };

    public int getMax();

    public int getCount();

    public int getQuota(Governable var1, int var2);

    public int use(Governable var1, int var2) throws OverquotaException;

    public int refund(Object var1);

    public static interface Governable {
    }

    public static class SimpleQuotas
    implements Quotas {
        protected int m_Max;
        protected AtomicInteger m_Count;

        public SimpleQuotas() {
            this(100);
        }

        public SimpleQuotas(int max) {
            this.m_Max = max;
            this.m_Count = new AtomicInteger(0);
        }

        public void setMax(int max) {
            this.m_Max = max;
        }

        @Override
        public int getMax() {
            return this.m_Max;
        }

        @Override
        public int getCount() {
            return this.m_Count.get();
        }

        protected int calcQuota(int quota, Governable resource, int concurrent) {
            if (quota <= 0) {
                return 0;
            }
            if (quota > 3) {
                return quota * 2 / 3;
            }
            return 1;
        }

        @Override
        public int getQuota(Governable resource, int concurrent) {
            return this.calcQuota(this.m_Max - this.m_Count.get(), resource, concurrent);
        }

        @Override
        public int use(Governable resource, int concurrent) throws OverquotaException {
            int q;
            int count = this.m_Count.incrementAndGet();
            if (count > this.m_Max) {
                this.m_Count.decrementAndGet();
                throw new OverquotaException("\u8d85\u989d{count:" + count + ",concurrent:" + concurrent + ",max:" + this.m_Max + ",res:" + resource + "}");
            }
            if (concurrent > 0 && concurrent >= (q = this.calcQuota(this.m_Max - count, resource, concurrent))) {
                this.m_Count.decrementAndGet();
                throw new RejectedExecutionException("\u6ee1\u989d{count:" + (count - 1) + ",concurrent:" + concurrent + ",quota:" + q + ",max:" + this.m_Max + ",res:" + resource + "}");
            }
            return count;
        }

        @Override
        public int refund(Object resource) {
            return this.m_Count.decrementAndGet();
        }

        public void reset() {
            this.m_Count.set(0);
        }

        public String toString() {
            return "{max:" + this.m_Max + ",count:" + this.m_Count.get() + "}";
        }
    }
}

