/*
 * Decompiled with CFR 0.152.
 */
package cn.weforward.common;

import cn.weforward.common.UniqueKey;
import cn.weforward.common.crypto.Hex;
import cn.weforward.common.sys.StackTracer;
import cn.weforward.common.util.StringUtil;
import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UniteId
implements Serializable,
UniqueKey {
    private static final long serialVersionUID = 1L;
    protected static final Logger _Logger = LoggerFactory.getLogger(UniteId.class);
    public static final char TYPE_SPEARATOR = '$';
    public static final char UNITE_SPEARATOR = '!';
    public static final char OBJECT_SPEARATOR = '.';
    public static final char PREFIX_SPEARATOR = '_';
    public static final char LN_SPEARATOR = '\n';
    public static final char ESCAPE = '^';
    public static final UniteId _nil = new UniteId(null);
    protected static final boolean _SpeartorChecked = "true".equals(System.getProperty("UniteId.SpeartorChecked", "false"));
    protected static volatile Map<Class<?>, String> _SimpleNameCache = Collections.emptyMap();
    protected final String m_Unite;
    protected final int m_IndexType;
    protected final int m_IndexId;
    protected int m_IntOrdinal;

    public UniteId(String uniteid) {
        if (uniteid == null || uniteid.length() == 0) {
            this.m_IndexType = 0;
            this.m_IndexId = 0;
            this.m_Unite = "";
            this.m_IntOrdinal = 0;
            return;
        }
        int idxId = -1;
        int idxType = uniteid.indexOf(36);
        if (-1 != idxType) {
            idxId = uniteid.indexOf(33, idxType);
        }
        if (-1 == idxType && -1 == idxId) {
            idxId = uniteid.indexOf(33, 0);
        }
        int n = idxType = -1 == idxType ? 0 : idxType + 1;
        if (-1 == idxId) {
            idxId = uniteid.length();
        }
        this.m_IndexType = idxType;
        this.m_IndexId = idxId;
        this.m_Unite = uniteid;
        this.m_IntOrdinal = Integer.MIN_VALUE;
    }

    protected UniteId(int ordinal, String caption, String type) {
        StringBuilder sb = new StringBuilder();
        if (!StringUtil.isEmpty(type)) {
            sb.append(type).append('$');
            this.m_IndexType = type.length() + 1;
        } else {
            this.m_IndexType = 0;
        }
        Hex.toHexFixed(ordinal, sb);
        this.m_IndexId = sb.length();
        if (!StringUtil.isEmpty(caption)) {
            sb.append('!').append(caption);
        }
        this.m_IntOrdinal = ordinal;
        this.m_Unite = sb.toString();
    }

    protected UniteId(String ordinal, int intOrdinal, String caption, String type) {
        this.m_IntOrdinal = intOrdinal;
        if (!StringUtil.isEmpty(type)) {
            if (_SpeartorChecked) {
                if (-1 != ordinal.indexOf(36) || -1 != ordinal.indexOf(33)) {
                    throw new IllegalArgumentException("\u8054\u5408ID\u7684\u5e8f\u53f7\u4e2d\u5305\u542b\u6709\u5206\u9694\u7b26\uff08\u82e5\u662f\u5fc5\u987b\u7684\u5e94\u4f7f\u7528UniteId.escapeOrdinal\u7f16\u7801\uff09\uff1a" + ordinal);
                }
            } else if (_Logger.isDebugEnabled() && (-1 != ordinal.indexOf(36) || -1 != ordinal.indexOf(33))) {
                _Logger.debug(StackTracer.printStackTrace(Thread.currentThread(), (Appendable)new StringBuilder("\u8054\u5408ID\u7684\u5e8f\u53f7\u4e2d\u5305\u542b\u6709\u5206\u9694\u7b26\uff08\u82e5\u662f\u5fc5\u987b\u7684\u5e94\u4f7f\u7528UniteId.escapeOrdinal\u7f16\u7801\uff09\uff1a").append(ordinal).append('\n')).toString());
            }
            ordinal = String.valueOf(type) + '$' + ordinal;
            this.m_IndexType = type.length() + 1;
        } else {
            this.m_IndexType = 0;
        }
        if (!StringUtil.isEmpty(caption)) {
            this.m_IndexId = ordinal.length();
            this.m_Unite = String.valueOf(ordinal) + '!' + caption;
        } else {
            this.m_Unite = ordinal;
            this.m_IndexId = ordinal.length();
        }
    }

    public String getType() {
        if (this.m_IndexType > 0) {
            return this.m_Unite.substring(0, this.m_IndexType - 1);
        }
        return null;
    }

    public String getId() {
        if (this.m_Unite.length() == this.m_IndexId) {
            return this.m_Unite;
        }
        return this.m_Unite.substring(0, this.m_IndexId);
    }

    @Override
    public String getKey() {
        return this.getId();
    }

    public String getOrdinal() {
        if (this.m_IndexId == 0) {
            return "";
        }
        return this.m_Unite.substring(this.m_IndexType, this.m_IndexId);
    }

    public int getIntOrdinal() {
        if (Integer.MIN_VALUE == this.m_IntOrdinal) {
            String uniteid = this.m_Unite.substring(this.m_IndexType, this.m_IndexId);
            this.m_IntOrdinal = 8 == uniteid.length() ? Hex.parseHex(uniteid, 8, 0) : (uniteid.length() > 8 && uniteid.charAt(8) == '_' ? Hex.parseHex(uniteid, 8, 0) : 0);
        }
        return this.m_IntOrdinal;
    }

    public String getCaption() {
        if (this.m_Unite.length() == this.m_IndexId) {
            return "";
        }
        return this.m_Unite.substring(this.m_IndexId + 1);
    }

    public String getUuid() {
        return this.getId();
    }

    public String withoutType() {
        if (this.m_IndexType > 0) {
            return this.m_Unite.substring(this.m_IndexType);
        }
        return this.m_Unite;
    }

    public String withoutPostfix() {
        int idx = this.m_Unite.indexOf(95, this.m_IndexType);
        if (idx < this.m_IndexType || idx >= this.m_IndexId) {
            return this.getId();
        }
        return this.m_Unite.substring(0, idx);
    }

    public boolean isDeclareCaption() {
        return this.m_IndexId > 0 && this.m_Unite.length() != this.m_IndexId;
    }

    public boolean isDeclareType() {
        return this.m_IndexType > 0;
    }

    public UniteId changeType(Class<?> type) {
        return this.changeType(UniteId.getType(type));
    }

    public UniteId changeType(String type) {
        if (StringUtil.eq(type, this.getType())) {
            return this;
        }
        return new UniteId(this.getOrdinal(), this.getIntOrdinal(), this.getCaption(), type);
    }

    public UniteId changeCaption(String caption) {
        if (StringUtil.eq(caption, this.getCaption())) {
            return this;
        }
        return new UniteId(this.getOrdinal(), this.getIntOrdinal(), caption, this.getType());
    }

    public boolean isEmpty() {
        return this.m_Unite.length() == 0;
    }

    public boolean equals(String ordinal) {
        return this.getId().equals(UniteId.getId(ordinal));
    }

    public boolean equals(int ordinal) {
        return this.m_IntOrdinal == ordinal;
    }

    public static final boolean isEmpty(UniteId unid) {
        return unid == null || unid.m_Unite.length() == 0;
    }

    public static final boolean isEmtpy(UniteId unid) {
        return UniteId.isEmpty(unid);
    }

    public static boolean equals(String id1, String id2) {
        return UniteId.getId(id1).equals(UniteId.getId(id2));
    }

    public static UniteId valueOf(String uniteid) {
        if (uniteid == null || uniteid.length() == 0) {
            return _nil;
        }
        return new UniteId(uniteid);
    }

    public static UniteId valueOf(String ordinal, String type, String caption) {
        return new UniteId(ordinal, 0, caption, type);
    }

    public static UniteId valueOf(String ordinal, int intOrdinal, String type, String caption) {
        return new UniteId(ordinal, intOrdinal, caption, type);
    }

    public static UniteId valueOf(int ordinal, String type, String caption) {
        return new UniteId(ordinal, caption, type);
    }

    public static UniteId valueOf(String ordinal, Class<?> type) {
        return new UniteId(ordinal, 0, null, UniteId.getType(type));
    }

    public static UniteId valueOf(String ordinal, int intOrdinal, Class<?> type) {
        if (StringUtil.isEmpty(ordinal) && intOrdinal == 0) {
            return _nil;
        }
        return new UniteId(ordinal, intOrdinal, null, UniteId.getType(type));
    }

    public static UniteId valueOf(int ordinal, Class<?> type) {
        return new UniteId(ordinal, null, UniteId.getType(type));
    }

    public static String getUniteId(String type, int ordinal) {
        return UniteId.getUniteId(ordinal, null, type);
    }

    public static String getUniteId(Class<?> type, int ordinal) {
        return UniteId.getUniteId(ordinal, null, UniteId.getType(type));
    }

    public static String getUniteId(Class<?> type, String ordinal) {
        return UniteId.getUniteId(ordinal, null, UniteId.getType(type));
    }

    public static String getUniteId(int ordinal, String caption) {
        return UniteId.getUniteId(Hex.toHex32(ordinal), caption, null);
    }

    public static String getUniteId(int ordinal, String caption, String type) {
        StringBuilder sb = new StringBuilder();
        if (type != null && type.length() > 0) {
            sb.append(type);
            sb.append('$');
        }
        Hex.toHexFixed(ordinal, sb);
        if (caption != null) {
            sb.append('!');
            sb.append(caption);
        }
        return sb.toString();
    }

    public static String getUniteId(String ordinal, String caption, String type) {
        StringBuilder sb = new StringBuilder();
        if (type != null && type.length() > 0) {
            sb.append(type);
            sb.append('$');
        }
        sb.append(ordinal);
        if (caption != null) {
            sb.append('!');
            sb.append(caption);
        }
        return sb.toString();
    }

    public static String getType(String uniteid) {
        return UniteId.valueOf(uniteid).getType();
    }

    public static String getType(Class<?> classOf) {
        return classOf == null ? null : UniteId.getSimpleName(classOf);
    }

    public static String getId(String uniteid) {
        return UniteId.valueOf(uniteid).getId();
    }

    public static String getUuid(String uniteid) {
        return UniteId.valueOf(uniteid).getId();
    }

    public static int getIntOrdinal(String uniteid) {
        return UniteId.valueOf(uniteid).getIntOrdinal();
    }

    public static String getOrdinal(String uniteid) {
        return UniteId.valueOf(uniteid).getOrdinal();
    }

    public static String getCaption(String uniteid) {
        return UniteId.valueOf(uniteid).getCaption();
    }

    public static UniteId fixId(String unitid, Class<?> clazz) {
        return UniteId.fixId(unitid, UniteId.getType(clazz));
    }

    public static UniteId fixId(String unitid, String type) {
        if (-1 != unitid.indexOf(36)) {
            return UniteId.valueOf(unitid);
        }
        int idx = unitid.indexOf(33);
        if (-1 == idx) {
            return UniteId.valueOf(unitid, type, null);
        }
        return UniteId.valueOf(unitid.substring(0, idx), type, null);
    }

    public static String changeType(String uniteid, String type) {
        int idx = uniteid.indexOf(36);
        if (-1 == idx) {
            return UniteId.getUniteId(uniteid, null, type);
        }
        return String.valueOf(type) + uniteid.substring(idx);
    }

    public static String changeType(String ordinal, Class<?> type) {
        return UniteId.changeType(ordinal, UniteId.getType(type));
    }

    public static String escapeOrdinal(String ordinal) {
        return ordinal.replace('$', '^');
    }

    public static String unescapeOrdinal(String ordinal) {
        return ordinal.replace('^', '$');
    }

    public static String getSimpleName(Class<?> clazz) {
        Map<Class<?>, String> cache = _SimpleNameCache;
        String name = cache.get(clazz);
        if (name == null) {
            name = clazz.getSimpleName();
            cache = new HashMap(cache);
            cache.put(clazz, name);
            _SimpleNameCache = cache;
        }
        return name;
    }

    public String stringValue() {
        return this.m_Unite;
    }

    public String toString() {
        return this.m_Unite;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (obj instanceof UniteId) {
            return this.getId().equals(((UniteId)obj).getId());
        }
        return this.getId().equals(UniteId.getId(obj.toString()));
    }
}

