/*
 * Decompiled with CFR 0.152.
 */
package cn.weforward.common.compiler;

import cn.weforward.common.compiler.CustomClassloaderJavaFileManager;
import cn.weforward.common.util.ClassUtil;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.charset.Charset;
import java.util.Collections;
import java.util.List;
import javax.tools.DiagnosticListener;
import javax.tools.JavaCompiler;
import javax.tools.JavaFileManager;
import javax.tools.JavaFileObject;
import javax.tools.StandardJavaFileManager;
import javax.tools.StandardLocation;
import javax.tools.ToolProvider;

public class CompilerJavaUtil {
    private static JavaCompiler COMPILER = ToolProvider.getSystemJavaCompiler();

    public static boolean complier(File src, File out, DiagnosticListener<? super JavaFileObject> diagnostics) throws IOException {
        URLClassLoader loader = new URLClassLoader(new URL[0], ClassUtil.getDefaultClassLoader());
        return CompilerJavaUtil.complier(loader, src, out, diagnostics);
    }

    public static boolean complier(URLClassLoader loader, File src, File out, DiagnosticListener<? super JavaFileObject> diagnostics) throws IOException {
        List<File> outfiles = Collections.singletonList(out);
        try (JavaFileManager fileManager = null;){
            StandardJavaFileManager standardJavaFileManager = COMPILER.getStandardFileManager(diagnostics, null, Charset.forName("UTF-8"));
            standardJavaFileManager.setLocation(StandardLocation.CLASS_OUTPUT, outfiles);
            Iterable<? extends JavaFileObject> compilationUnits = standardJavaFileManager.getJavaFileObjects(src);
            fileManager = new CustomClassloaderJavaFileManager(loader, standardJavaFileManager);
            JavaCompiler.CompilationTask task = COMPILER.getTask(null, fileManager, diagnostics, null, null, compilationUnits);
            boolean bl = task.call();
            return bl;
        }
    }

    public static File clean(File file) throws IOException {
        if (file.exists()) {
            CompilerJavaUtil.delete(file);
        }
        if (!file.mkdirs()) {
            throw new IOException("\u65e0\u6cd5\u521b\u5efa[" + file + "]");
        }
        return file;
    }

    public static void delete(File file) throws IOException {
        if (!file.exists()) {
            return;
        }
        if (file.isDirectory()) {
            File[] fileArray = file.listFiles();
            int n = fileArray.length;
            int n2 = 0;
            while (n2 < n) {
                File f = fileArray[n2];
                CompilerJavaUtil.delete(f);
                ++n2;
            }
            boolean isSuccess = file.delete();
            if (!isSuccess) {
                throw new IOException("\u5220\u9664" + file.getAbsolutePath() + "\u5931\u8d25");
            }
        } else {
            boolean isSuccess = file.delete();
            if (!isSuccess) {
                throw new IOException("\u5220\u9664" + file.getAbsolutePath() + "\u5931\u8d25");
            }
        }
    }
}

