/*
 * Decompiled with CFR 0.152.
 */
package cn.weforward.common.compiler;

import cn.weforward.common.compiler.CustomJavaFileObject;
import cn.weforward.common.compiler.PackageInternalsFinder;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Set;
import javax.tools.FileObject;
import javax.tools.JavaFileManager;
import javax.tools.JavaFileObject;
import javax.tools.StandardJavaFileManager;
import javax.tools.StandardLocation;

class CustomClassloaderJavaFileManager
implements JavaFileManager {
    private ClassLoader m_ClassLoader;
    private StandardJavaFileManager m_StandardFileManager;
    private PackageInternalsFinder m_Finder;

    public CustomClassloaderJavaFileManager(ClassLoader classLoader, StandardJavaFileManager standardFileManager) {
        this.m_ClassLoader = classLoader;
        this.m_StandardFileManager = standardFileManager;
        this.m_Finder = new PackageInternalsFinder(classLoader);
    }

    @Override
    public ClassLoader getClassLoader(JavaFileManager.Location location) {
        return this.m_ClassLoader;
    }

    @Override
    public Iterable<JavaFileObject> list(JavaFileManager.Location location, String packageName, Set<JavaFileObject.Kind> kinds, boolean recurse) throws IOException {
        if (location == StandardLocation.PLATFORM_CLASS_PATH) {
            return this.m_StandardFileManager.list(location, packageName, kinds, recurse);
        }
        if (location == StandardLocation.CLASS_PATH && kinds.contains((Object)JavaFileObject.Kind.CLASS)) {
            ArrayList<JavaFileObject> result = new ArrayList<JavaFileObject>();
            for (JavaFileObject v : this.m_StandardFileManager.list(location, packageName, kinds, recurse)) {
                result.add(v);
            }
            for (JavaFileObject v : this.m_Finder.find(packageName)) {
                result.add(v);
            }
            return result;
        }
        return this.m_StandardFileManager.list(location, packageName, kinds, recurse);
    }

    @Override
    public String inferBinaryName(JavaFileManager.Location location, JavaFileObject file) {
        if (file instanceof CustomJavaFileObject) {
            return ((CustomJavaFileObject)file).binaryName();
        }
        return this.m_StandardFileManager.inferBinaryName(location, file);
    }

    @Override
    public boolean isSameFile(FileObject a, FileObject b) {
        return this.m_StandardFileManager.isSameFile(a, b);
    }

    @Override
    public boolean handleOption(String current, Iterator<String> remaining) {
        return this.handleOption(current, remaining);
    }

    @Override
    public boolean hasLocation(JavaFileManager.Location location) {
        return this.m_StandardFileManager.hasLocation(location);
    }

    @Override
    public JavaFileObject getJavaFileForInput(JavaFileManager.Location location, String className, JavaFileObject.Kind kind) throws IOException {
        return this.m_StandardFileManager.getJavaFileForInput(location, className, kind);
    }

    @Override
    public JavaFileObject getJavaFileForOutput(JavaFileManager.Location location, String className, JavaFileObject.Kind kind, FileObject sibling) throws IOException {
        return this.m_StandardFileManager.getJavaFileForOutput(location, className, kind, sibling);
    }

    @Override
    public FileObject getFileForInput(JavaFileManager.Location location, String packageName, String relativeName) throws IOException {
        return this.m_StandardFileManager.getFileForInput(location, packageName, relativeName);
    }

    @Override
    public FileObject getFileForOutput(JavaFileManager.Location location, String packageName, String relativeName, FileObject sibling) throws IOException {
        return this.m_StandardFileManager.getFileForOutput(location, packageName, relativeName, sibling);
    }

    @Override
    public void flush() throws IOException {
        this.m_StandardFileManager.flush();
    }

    @Override
    public void close() throws IOException {
        this.m_StandardFileManager.close();
    }

    @Override
    public int isSupportedOption(String option) {
        return this.m_StandardFileManager.isSupportedOption(option);
    }
}

