/*
 * Decompiled with CFR 0.152.
 */
package cn.weforward.common.compiler;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.net.URI;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.NestingKind;
import javax.tools.JavaFileObject;

class CustomJavaFileObject
implements JavaFileObject {
    private String m_BinaryName;
    private URI m_Uri;
    private String m_Name;

    public CustomJavaFileObject(String binaryName, URI uri) {
        this.m_Uri = uri;
        this.m_BinaryName = binaryName;
        this.m_Name = uri.getPath() == null ? uri.getSchemeSpecificPart() : uri.getPath();
    }

    public String binaryName() {
        return this.m_BinaryName;
    }

    @Override
    public String getName() {
        return this.m_Name;
    }

    @Override
    public URI toUri() {
        return this.m_Uri;
    }

    @Override
    public InputStream openInputStream() throws IOException {
        return this.m_Uri.toURL().openStream();
    }

    @Override
    public OutputStream openOutputStream() throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public Reader openReader(boolean ignoreEncodingErrors) throws IOException {
        return new InputStreamReader(this.m_Uri.toURL().openStream());
    }

    @Override
    public CharSequence getCharContent(boolean ignoreEncodingErrors) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public Writer openWriter() throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public long getLastModified() {
        return 0L;
    }

    @Override
    public boolean delete() {
        throw new UnsupportedOperationException();
    }

    @Override
    public JavaFileObject.Kind getKind() {
        return JavaFileObject.Kind.CLASS;
    }

    @Override
    public boolean isNameCompatible(String simpleName, JavaFileObject.Kind kind) {
        String baseName = String.valueOf(simpleName) + kind.extension;
        return kind.equals((Object)this.getKind()) && (baseName.equals(this.getName()) || this.getName().endsWith("/" + baseName));
    }

    @Override
    public NestingKind getNestingKind() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Modifier getAccessLevel() {
        throw new UnsupportedOperationException();
    }

    public String toString() {
        return "CustomJavaFileObject{uri=" + this.m_Uri + '}';
    }
}

