/*
 * Decompiled with CFR 0.152.
 */
package cn.weforward.common.compiler;

import cn.weforward.common.compiler.CustomJavaFileObject;
import java.io.File;
import java.io.IOException;
import java.net.JarURLConnection;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.List;
import java.util.jar.JarEntry;
import javax.tools.JavaFileObject;

class PackageInternalsFinder {
    private static final String CLASS_FILE_EXTENSION = ".class";
    private ClassLoader m_ClassLoader;

    public PackageInternalsFinder(ClassLoader classLoader) {
        this.m_ClassLoader = classLoader;
    }

    public List<JavaFileObject> find(String packageName) throws IOException {
        String javaPackageName = packageName.replaceAll("\\.", "/");
        ArrayList<JavaFileObject> result = new ArrayList<JavaFileObject>();
        Enumeration<URL> urlEnumeration = this.m_ClassLoader.getResources(javaPackageName);
        while (urlEnumeration.hasMoreElements()) {
            URL packageFolderURL = urlEnumeration.nextElement();
            result.addAll(this.listUnder(packageName, packageFolderURL));
        }
        return result;
    }

    private Collection<JavaFileObject> listUnder(String packageName, URL packageFolderURL) {
        File directory = new File(packageFolderURL.getFile());
        if (directory.isDirectory()) {
            return this.processDir(packageName, directory);
        }
        return this.processJar(packageFolderURL);
    }

    private List<JavaFileObject> processJar(URL packageFolderURL) {
        ArrayList<JavaFileObject> result = new ArrayList<JavaFileObject>();
        try {
            String e = packageFolderURL.toExternalForm();
            int index = e.lastIndexOf("!");
            String jarUri = e.substring(0, index);
            JarURLConnection jarConn = (JarURLConnection)packageFolderURL.openConnection();
            String rootEntryName = jarConn.getEntryName();
            int rootEnd = rootEntryName.length() + 1;
            Enumeration<JarEntry> entryEnum = jarConn.getJarFile().entries();
            while (entryEnum.hasMoreElements()) {
                JarEntry jarEntry = entryEnum.nextElement();
                String name = jarEntry.getName();
                if (!name.startsWith(rootEntryName) || name.indexOf(47, rootEnd) != -1) continue;
                URI uri = URI.create(String.valueOf(jarUri) + "!/" + name);
                if (name.endsWith(CLASS_FILE_EXTENSION)) {
                    String binaryName = name.replaceAll("/", ".");
                    binaryName = binaryName.replaceAll(".class$", "");
                    result.add(new CustomJavaFileObject(binaryName, uri));
                    continue;
                }
                if (!name.endsWith(".jar")) continue;
                this.processJar(uri.toURL());
            }
        }
        catch (Exception e) {
            throw new RuntimeException("\u5904\u7406\u5305\u5f02\u5e38:" + e.getMessage(), e);
        }
        return result;
    }

    private List<JavaFileObject> processDir(String packageName, File directory) {
        File[] childFiles;
        ArrayList<JavaFileObject> result = new ArrayList<JavaFileObject>();
        File[] fileArray = childFiles = directory.listFiles();
        int n = childFiles.length;
        int n2 = 0;
        while (n2 < n) {
            File childFile = fileArray[n2];
            if (childFile.isFile() && childFile.getName().endsWith(CLASS_FILE_EXTENSION)) {
                String binaryName = String.valueOf(packageName) + "." + childFile.getName();
                binaryName = binaryName.replaceAll(".class$", "");
                result.add(new CustomJavaFileObject(binaryName, childFile.toURI()));
            }
            ++n2;
        }
        return result;
    }
}

