/*
 * Decompiled with CFR 0.152.
 */
package cn.weforward.common.crypto;

import cn.weforward.common.execption.InvalidFormatException;
import cn.weforward.common.io.BytesOutputStream;
import cn.weforward.common.util.Bytes;
import cn.weforward.common.util.StringBuilderPool;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;

public class Base64 {
    private static final int BASE_BIT = 6;
    private static final int EIGHT_BIT = 8;
    private static final int SIXTEEN_BIT = 16;
    private static final int TWENTY_FOUR_BIT = 24;
    private static final int EIGHT_MASK = 255;
    private static final int SIGN = -128;
    private static final char PAD = '=';
    private static final int[] _Base64DecodeTable = new int[255];
    private static final char[] _Base64EncodeTable = new char[]{'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '+', '/'};

    static {
        int i = 0;
        while (i < _Base64DecodeTable.length) {
            Base64._Base64DecodeTable[i] = -2;
            ++i;
        }
        i = 0;
        while (i < _Base64EncodeTable.length) {
            Base64._Base64DecodeTable[Base64._Base64EncodeTable[i]] = i;
            ++i;
        }
        Base64._Base64DecodeTable[61] = -1;
    }

    public static String encode(byte[] bytes) {
        return Base64.encode(bytes, 0, bytes.length);
    }

    public static String encode(byte[] bytes, int offset, int len) {
        StringBuilder builder = StringBuilderPool._8k.poll();
        try {
            String string = Base64.encode(builder, bytes, offset, len).toString();
            return string;
        }
        catch (IOException e) {
            return null;
        }
        finally {
            StringBuilderPool._8k.offer(builder);
        }
    }

    public static Appendable encode(Appendable appender, byte[] bytes, int offset, int len) throws IOException {
        byte val1;
        if (bytes == null) {
            return null;
        }
        if (offset < 0 || len < 0 || offset + len > bytes.length) {
            throw new IllegalArgumentException("offset[" + offset + "]+len[" + len + "] over{0~" + bytes.length + "}");
        }
        if (len == 0) {
            return appender;
        }
        int dataBits = len * 8;
        int groups = dataBits / 24;
        int fewer = dataBits % 24;
        int bytesIdx = offset;
        byte k = 0;
        byte l = 0;
        byte b1 = 0;
        byte b2 = 0;
        byte b3 = 0;
        int i = 0;
        while (i < groups) {
            b1 = bytes[bytesIdx++];
            b2 = bytes[bytesIdx++];
            b3 = bytes[bytesIdx++];
            l = (byte)(b2 & 0xF);
            k = (byte)(b1 & 3);
            byte val12 = (b1 & 0xFFFFFF80) == 0 ? (byte)(b1 >> 2) : (byte)(b1 >> 2 ^ 0xC0);
            byte val2 = (b2 & 0xFFFFFF80) == 0 ? (byte)(b2 >> 4) : (byte)(b2 >> 4 ^ 0xF0);
            byte val3 = (b3 & 0xFFFFFF80) == 0 ? (byte)(b3 >> 6) : (byte)(b3 >> 6 ^ 0xFC);
            appender.append(_Base64EncodeTable[val12]);
            appender.append(_Base64EncodeTable[val2 | k << 4]);
            appender.append(_Base64EncodeTable[l << 2 | val3]);
            appender.append(_Base64EncodeTable[b3 & 0x3F]);
            ++i;
        }
        if (fewer == 8) {
            b1 = bytes[bytesIdx];
            k = (byte)(b1 & 3);
            val1 = (b1 & 0xFFFFFF80) == 0 ? (byte)(b1 >> 2) : (byte)(b1 >> 2 ^ 0xC0);
            appender.append(_Base64EncodeTable[val1]);
            appender.append(_Base64EncodeTable[k << 4]);
            appender.append('=');
            appender.append('=');
        } else if (fewer == 16) {
            b1 = bytes[bytesIdx];
            b2 = bytes[bytesIdx + 1];
            l = (byte)(b2 & 0xF);
            k = (byte)(b1 & 3);
            val1 = (b1 & 0xFFFFFF80) == 0 ? (byte)(b1 >> 2) : (byte)(b1 >> 2 ^ 0xC0);
            byte val2 = (b2 & 0xFFFFFF80) == 0 ? (byte)(b2 >> 4) : (byte)(b2 >> 4 ^ 0xF0);
            appender.append(_Base64EncodeTable[val1]);
            appender.append(_Base64EncodeTable[val2 | k << 4]);
            appender.append(_Base64EncodeTable[l << 2]);
            appender.append('=');
        }
        return appender;
    }

    private static final int readFully(InputStream in, byte[] buffer) throws IOException {
        int off = 0;
        int len = buffer.length;
        while (len > 0) {
            int n = in.read(buffer, off, len);
            if (n < 0) break;
            off += n;
            len -= n;
        }
        return off;
    }

    public static Appendable encode(InputStream in, Appendable out) throws IOException {
        byte v1;
        byte v0;
        int ret;
        byte[] bytes = new byte[3];
        while (3 == (ret = Base64.readFully(in, bytes))) {
            v0 = bytes[0];
            v1 = bytes[1];
            byte v2 = bytes[2];
            byte l = (byte)(v1 & 0xF);
            byte k = (byte)(v0 & 3);
            v0 = (v0 & 0xFFFFFF80) == 0 ? (byte)(v0 >> 2) : (byte)(v0 >> 2 ^ 0xC0);
            v1 = (v1 & 0xFFFFFF80) == 0 ? (byte)(v1 >> 4) : (byte)(v1 >> 4 ^ 0xF0);
            v2 = (v2 & 0xFFFFFF80) == 0 ? (byte)(v2 >> 6) : (byte)(v2 >> 6 ^ 0xFC);
            out.append(_Base64EncodeTable[v0]);
            out.append(_Base64EncodeTable[v1 | k << 4]);
            out.append(_Base64EncodeTable[l << 2 | v2]);
            out.append(_Base64EncodeTable[bytes[2] & 0x3F]);
        }
        if (2 == ret) {
            v0 = bytes[0];
            v1 = bytes[1];
            byte l = (byte)(v1 & 0xF);
            byte k = (byte)(v0 & 3);
            v0 = (v0 & 0xFFFFFF80) == 0 ? (byte)(v0 >> 2) : (byte)(v0 >> 2 ^ 0xC0);
            v1 = (v1 & 0xFFFFFF80) == 0 ? (byte)(v1 >> 4) : (byte)(v1 >> 4 ^ 0xF0);
            out.append(_Base64EncodeTable[v0]);
            out.append(_Base64EncodeTable[v1 | k << 4]);
            out.append(_Base64EncodeTable[l << 2]);
            out.append('=');
        } else if (1 == ret) {
            byte b0 = bytes[0];
            byte k = (byte)(b0 & 3);
            b0 = (b0 & 0xFFFFFF80) == 0 ? (byte)(b0 >> 2) : (byte)(b0 >> 2 ^ 0xC0);
            out.append(_Base64EncodeTable[b0]);
            out.append(_Base64EncodeTable[k << 4]);
            out.append('=');
            out.append('=');
        }
        return out;
    }

    public static byte[] decode(byte[] base64) throws IOException {
        if (base64 == null) {
            return null;
        }
        return Base64.decode(base64, 0, base64.length);
    }

    public static byte[] decode(byte[] base64, int offset, int len) throws IOException {
        if (base64 == null) {
            return null;
        }
        return Base64.decode(new WrapBytes(base64, offset, len)).getBytes();
    }

    public static byte[] decode(InputStream base64) throws IOException {
        if (base64 == null) {
            return null;
        }
        return Base64.decode(new WrapInputStream(base64)).getBytes();
    }

    public static int decode(Base64Input in, OutputStream out) throws IOException {
        byte ch;
        if (in == null) {
            return 0;
        }
        int bits = 0;
        int remaining = 0;
        int pos = 0;
        int count = 0;
        while ((ch = in.read()) != 0) {
            if (32 != ch && 9 != ch && 13 != ch && 10 != ch) {
                int digit = _Base64DecodeTable[ch & 0x7F];
                if (digit < -1) {
                    out.close();
                    throw new InvalidFormatException(in.toString(), pos - 1);
                }
                if (-1 == digit) break;
                bits = bits << 6 | (digit &= 0x3F);
                if ((remaining += 6) >= 8) {
                    int scratch = bits >> (remaining -= 8);
                    out.write(scratch & 0xFF);
                    ++count;
                }
            }
            ++pos;
        }
        if (remaining > 0 && 2 != remaining && 4 != remaining && (bits &= (1 << remaining) - 1) != 0) {
            throw new InvalidFormatException(in.toString(), pos - 1);
        }
        return count;
    }

    public static Bytes decode(Base64Input base64) throws IOException {
        if (base64 == null) {
            return Bytes.empty();
        }
        int size = base64.available();
        if (size < 1) {
            return Bytes.empty();
        }
        BytesOutputStream result = new BytesOutputStream((size = size * 3 / 4) < 16 ? 16 : size);
        Base64.decode(base64, result);
        result.close();
        return result.getBytes();
    }

    public static byte[] decode(String base64) {
        Bytes bytes;
        if (base64 == null || base64.length() == 0) {
            return null;
        }
        try {
            bytes = Base64.decode(new WrapString(base64));
        }
        catch (IOException e) {
            throw new InvalidFormatException(base64);
        }
        if (bytes.getFree() > 0) {
            return Arrays.copyOfRange(bytes.getBytes(), bytes.getOffset(), bytes.getSize());
        }
        return bytes.getBytes();
    }

    public static interface Base64Input {
        public int available() throws IOException;

        public byte read() throws IOException;
    }

    public static class WrapBytes
    implements Base64Input {
        final byte[] m_Base64;
        int m_Offset;
        final int m_Len;

        public WrapBytes(byte[] base64, int offset, int len) {
            this.m_Base64 = base64;
            this.m_Offset = offset;
            this.m_Len = len + this.m_Offset;
        }

        @Override
        public int available() throws IOException {
            return this.m_Len - this.m_Offset;
        }

        @Override
        public byte read() throws IOException {
            if (this.m_Offset == this.m_Len) {
                ++this.m_Offset;
                return 0;
            }
            if (this.m_Offset > this.m_Len) {
                throw new EOFException("\u65e0\u66f4\u591a\u5185\u5bb9[" + this.m_Offset + "]");
            }
            return this.m_Base64[this.m_Offset++];
        }
    }

    public static class WrapInputStream
    implements Base64Input {
        protected InputStream m_Base64;

        public WrapInputStream(InputStream base64) {
            this.m_Base64 = base64;
        }

        @Override
        public int available() throws IOException {
            if (this.m_Base64 == null) {
                return 0;
            }
            return this.m_Base64.available();
        }

        @Override
        public byte read() throws IOException {
            if (this.m_Base64 == null) {
                throw new EOFException("\u5df2\u8bfb\u53d6\u5b8c\u5173\u95ed");
            }
            int ret = this.m_Base64.read();
            if (ret < 0) {
                this.m_Base64.close();
                this.m_Base64 = null;
                return 0;
            }
            return (byte)ret;
        }

        protected void finalize() throws Throwable {
            if (this.m_Base64 != null) {
                this.m_Base64.close();
                this.m_Base64 = null;
            }
        }
    }

    public static class WrapString
    implements Base64Input {
        protected final String m_Base64;
        protected int m_Pos;

        public WrapString(String base64, int offset) {
            this.m_Base64 = base64;
            this.m_Pos = offset;
        }

        public WrapString(String base64) {
            this.m_Base64 = base64;
        }

        @Override
        public int available() throws IOException {
            return this.m_Base64.length() - this.m_Pos;
        }

        @Override
        public byte read() throws IOException {
            if (this.m_Base64.length() == this.m_Pos) {
                ++this.m_Pos;
                return 0;
            }
            if (this.m_Pos > this.m_Base64.length()) {
                throw new EOFException("\u65e0\u66f4\u591a\u5b57\u7b26\u5185\u5bb9[" + this.m_Pos + "]");
            }
            return (byte)this.m_Base64.charAt(this.m_Pos++);
        }

        public String toString() {
            return this.m_Base64;
        }
    }
}

