/*
 * Decompiled with CFR 0.152.
 */
package cn.weforward.common.crypto;

import cn.weforward.common.crypto.Hex;
import cn.weforward.common.execption.UnsupportedException;
import cn.weforward.common.util.RingBuffer;
import cn.weforward.common.util.StringUtil;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public class Hasher {
    public static final RingBuffer<MessageDigest> _md5Pool = new RingBuffer<MessageDigest>(64){

        @Override
        protected MessageDigest onEmpty() {
            try {
                return MessageDigest.getInstance("MD5");
            }
            catch (NoSuchAlgorithmException e) {
                throw new UnsupportedException(e);
            }
        }

        @Override
        public boolean offer(MessageDigest item) {
            if (item == null) {
                return false;
            }
            item.reset();
            return super.offer(item);
        }
    };

    public static int stringHash(char ch, int hash) {
        hash = 31 * hash + ch;
        return hash;
    }

    public static int stringHash(String str, int hash) {
        if (str == null) {
            return hash;
        }
        int len = str.length();
        int i = 0;
        while (i < len) {
            hash = 31 * hash + str.charAt(i);
            ++i;
        }
        return hash;
    }

    public static int stringHash(CharSequence str, int beginIndex, int endIndex, int hash) {
        while (beginIndex < endIndex) {
            hash = 31 * hash + str.charAt(beginIndex);
            ++beginIndex;
        }
        return hash;
    }

    public static final String simpleHash(String str) {
        int h = Hasher.hashInt32(str, 0);
        return String.valueOf(h < 0 ? 0x100000000L + (long)h : (long)h);
    }

    public static int hashInt32(String str, int sign) {
        if (str == null || str.length() == 0) {
            return sign;
        }
        int i = 0;
        int len = str.length();
        int sum = sign >> 16 & 0xFFFF;
        int h = sign & 0xFFFF;
        while (i < len) {
            int a;
            if ((a = str.charAt(i++)) < 256) {
                a <<= 8;
                if (i < len) {
                    a |= str.charAt(i);
                    a *= i++;
                } else {
                    a *= i;
                }
            } else {
                a *= i;
            }
            sum += sum ^ a;
            h += a;
            h &= 0xFFFF;
            sum &= 0xFFFF;
        }
        if (sum > Short.MAX_VALUE) {
            long fix = sum;
            fix <<= 16;
            return (int)((fix |= (long)h) - 0x100000000L);
        }
        return sum << 16 | h;
    }

    public static long hashInt64(String str, int sign) {
        if (str == null || str.length() == 0) {
            return sign;
        }
        long hash = Hasher.hashInt32(str, sign);
        hash = hash << 32 >>> 32;
        return hash |= (long)Hasher.stringHash(str, 0) << 32;
    }

    public static String md5(String content) {
        byte[] bytes = content.getBytes(StringUtil.UTF8);
        MessageDigest md = _md5Pool.poll();
        try {
            md.update(bytes);
            String string = Hex.encode(md.digest());
            return string;
        }
        finally {
            _md5Pool.offer(md);
        }
    }
}

