/*
 * Decompiled with CFR 0.152.
 */
package cn.weforward.common.crypto;

import cn.weforward.common.util.StringUtil;
import java.io.IOException;

public class Hex {
    public static final char[] _hexDigits = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
    static final int[] _hexTable0_f;

    static {
        int[] nArray = new int[103];
        nArray[0] = -1;
        nArray[1] = -1;
        nArray[2] = -1;
        nArray[3] = -1;
        nArray[4] = -1;
        nArray[5] = -1;
        nArray[6] = -1;
        nArray[7] = -1;
        nArray[8] = -1;
        nArray[9] = -1;
        nArray[10] = -1;
        nArray[11] = -1;
        nArray[12] = -1;
        nArray[13] = -1;
        nArray[14] = -1;
        nArray[15] = -1;
        nArray[16] = -1;
        nArray[17] = -1;
        nArray[18] = -1;
        nArray[19] = -1;
        nArray[20] = -1;
        nArray[21] = -1;
        nArray[22] = -1;
        nArray[23] = -1;
        nArray[24] = -1;
        nArray[25] = -1;
        nArray[26] = -1;
        nArray[27] = -1;
        nArray[28] = -1;
        nArray[29] = -1;
        nArray[30] = -1;
        nArray[31] = -1;
        nArray[32] = -1;
        nArray[33] = -1;
        nArray[34] = -1;
        nArray[35] = -1;
        nArray[36] = -1;
        nArray[37] = -1;
        nArray[38] = -1;
        nArray[39] = -1;
        nArray[40] = -1;
        nArray[41] = -1;
        nArray[42] = -1;
        nArray[43] = -1;
        nArray[44] = -1;
        nArray[45] = -1;
        nArray[46] = -1;
        nArray[47] = -1;
        nArray[49] = 1;
        nArray[50] = 2;
        nArray[51] = 3;
        nArray[52] = 4;
        nArray[53] = 5;
        nArray[54] = 6;
        nArray[55] = 7;
        nArray[56] = 8;
        nArray[57] = 9;
        nArray[58] = -1;
        nArray[59] = -1;
        nArray[60] = -1;
        nArray[61] = -1;
        nArray[62] = -1;
        nArray[63] = -1;
        nArray[64] = -1;
        nArray[65] = 10;
        nArray[66] = 11;
        nArray[67] = 12;
        nArray[68] = 13;
        nArray[69] = 14;
        nArray[70] = 15;
        nArray[71] = -1;
        nArray[72] = -1;
        nArray[73] = -1;
        nArray[74] = -1;
        nArray[75] = -1;
        nArray[76] = -1;
        nArray[77] = -1;
        nArray[78] = -1;
        nArray[79] = -1;
        nArray[80] = -1;
        nArray[81] = -1;
        nArray[82] = -1;
        nArray[83] = -1;
        nArray[84] = -1;
        nArray[85] = -1;
        nArray[86] = -1;
        nArray[87] = -1;
        nArray[88] = -1;
        nArray[89] = -1;
        nArray[90] = -1;
        nArray[91] = -1;
        nArray[92] = -1;
        nArray[93] = -1;
        nArray[94] = -1;
        nArray[95] = -1;
        nArray[96] = -1;
        nArray[97] = 10;
        nArray[98] = 11;
        nArray[99] = 12;
        nArray[100] = 13;
        nArray[101] = 14;
        nArray[102] = 15;
        _hexTable0_f = nArray;
    }

    public static String encode(byte[] data) {
        return Hex.encode(data, 0, data.length);
    }

    public static String encode(byte[] data, int offset, int len) {
        if (data == null) {
            return null;
        }
        char[] hex = new char[len * 2];
        int k = 0;
        int i = 0;
        while (i < len) {
            byte bt = data[i + offset];
            hex[k++] = _hexDigits[bt >> 4 & 0xF];
            hex[k++] = _hexDigits[bt & 0xF];
            ++i;
        }
        return new String(hex);
    }

    public static byte[] decode(String hex) {
        if (hex == null || hex.length() == 0) {
            return null;
        }
        if (1 == (1 & hex.length())) {
            throw new IllegalArgumentException("HEX\u683c\u5f0f\u9519\u8bef\uff1a" + StringUtil.limit(hex, 50));
        }
        byte[] data = new byte[hex.length() / 2];
        int k = 0;
        int i = 0;
        while (i < hex.length()) {
            char ch;
            if ((ch = hex.charAt(i++)) < '\u0000' || ch >= _hexTable0_f.length || -1 == _hexTable0_f[ch]) {
                throw new IllegalArgumentException("HEX\u683c\u5f0f\u9519\u8bef\uff0c\u5728" + i + "\u4f4d\u7f6e");
            }
            int bit8 = _hexTable0_f[ch];
            ch = hex.charAt(i);
            if (ch < '\u0000' || ch >= _hexTable0_f.length || -1 == _hexTable0_f[ch]) {
                throw new IllegalArgumentException("HEX\u683c\u5f0f\u9519\u8bef\uff0c\u5728" + i + "\u4f4d\u7f6e");
            }
            bit8 = bit8 << 4 & 0xF0;
            data[k++] = (byte)(bit8 |= 0xF & _hexTable0_f[ch]);
            ++i;
        }
        return data;
    }

    public static byte decodeByte(CharSequence hex, int offset) {
        char ch;
        if ((ch = hex.charAt(offset++)) < '\u0000' || ch >= _hexTable0_f.length || -1 == _hexTable0_f[ch]) {
            throw new IllegalArgumentException("HEX\u683c\u5f0f\u9519\u8bef\uff0c\u5728" + offset + "\u4f4d\u7f6e");
        }
        int bit8 = _hexTable0_f[ch];
        ch = hex.charAt(offset);
        if (ch < '\u0000' || ch >= _hexTable0_f.length || -1 == _hexTable0_f[ch]) {
            throw new IllegalArgumentException("HEX\u683c\u5f0f\u9519\u8bef\uff0c\u5728" + offset + "\u4f4d\u7f6e");
        }
        bit8 = bit8 << 4 & 0xF0;
        return (byte)(bit8 |= 0xF & _hexTable0_f[ch]);
    }

    public static StringBuilder toHexFixed(int val, StringBuilder sb) {
        if (sb == null) {
            sb = new StringBuilder(8);
        }
        if (val < 0 || val >= 0x10000000) {
            sb.append(_hexDigits[val >> 28 & 0xF]);
            sb.append(_hexDigits[val >> 24 & 0xF]);
            sb.append(_hexDigits[val >> 20 & 0xF]);
            sb.append(_hexDigits[val >> 16 & 0xF]);
            sb.append(_hexDigits[val >> 12 & 0xF]);
            sb.append(_hexDigits[val >> 8 & 0xF]);
            sb.append(_hexDigits[val >> 4 & 0xF]);
            sb.append(_hexDigits[val & 0xF]);
        } else if (val >= 0x1000000) {
            sb.append('0');
            sb.append(_hexDigits[val >> 24 & 0xF]);
            sb.append(_hexDigits[val >> 20 & 0xF]);
            sb.append(_hexDigits[val >> 16 & 0xF]);
            sb.append(_hexDigits[val >> 12 & 0xF]);
            sb.append(_hexDigits[val >> 8 & 0xF]);
            sb.append(_hexDigits[val >> 4 & 0xF]);
            sb.append(_hexDigits[val & 0xF]);
        } else if (val >= 0x100000) {
            sb.append("00");
            sb.append(_hexDigits[val >> 20 & 0xF]);
            sb.append(_hexDigits[val >> 16 & 0xF]);
            sb.append(_hexDigits[val >> 12 & 0xF]);
            sb.append(_hexDigits[val >> 8 & 0xF]);
            sb.append(_hexDigits[val >> 4 & 0xF]);
            sb.append(_hexDigits[val & 0xF]);
        } else if (val >= 65536) {
            sb.append("000");
            sb.append(_hexDigits[val >> 16 & 0xF]);
            sb.append(_hexDigits[val >> 12 & 0xF]);
            sb.append(_hexDigits[val >> 8 & 0xF]);
            sb.append(_hexDigits[val >> 4 & 0xF]);
            sb.append(_hexDigits[val & 0xF]);
        } else if (val >= 4096) {
            sb.append("0000");
            sb.append(_hexDigits[val >> 12 & 0xF]);
            sb.append(_hexDigits[val >> 8 & 0xF]);
            sb.append(_hexDigits[val >> 4 & 0xF]);
            sb.append(_hexDigits[val & 0xF]);
        } else if (val >= 256) {
            sb.append("00000");
            sb.append(_hexDigits[val >> 8 & 0xF]);
            sb.append(_hexDigits[val >> 4 & 0xF]);
            sb.append(_hexDigits[val & 0xF]);
        } else if (val >= 16) {
            sb.append("000000");
            sb.append(_hexDigits[val >> 4 & 0xF]);
            sb.append(_hexDigits[val & 0xF]);
        } else if (val >= 1) {
            sb.append("0000000");
            sb.append(_hexDigits[val & 0xF]);
        } else {
            sb.append("00000000");
            return sb;
        }
        return sb;
    }

    public static void toHexFixed24(int i24, StringBuilder builder) {
        if (i24 >= 0x1000000) {
            throw new NumberFormatException("i24(" + i24 + ")>0x00FFFFFF");
        }
        if (i24 >= 0x100000) {
            builder.append(_hexDigits[i24 >> 20 & 0xF]);
            builder.append(_hexDigits[i24 >> 16 & 0xF]);
            builder.append(_hexDigits[i24 >> 12 & 0xF]);
            builder.append(_hexDigits[i24 >> 8 & 0xF]);
            builder.append(_hexDigits[i24 >> 4 & 0xF]);
            builder.append(_hexDigits[i24 & 0xF]);
        } else if (i24 >= 65536) {
            builder.append("0");
            builder.append(_hexDigits[i24 >> 16 & 0xF]);
            builder.append(_hexDigits[i24 >> 12 & 0xF]);
            builder.append(_hexDigits[i24 >> 8 & 0xF]);
            builder.append(_hexDigits[i24 >> 4 & 0xF]);
            builder.append(_hexDigits[i24 & 0xF]);
        } else if (i24 >= 4096) {
            builder.append("00");
            builder.append(_hexDigits[i24 >> 12 & 0xF]);
            builder.append(_hexDigits[i24 >> 8 & 0xF]);
            builder.append(_hexDigits[i24 >> 4 & 0xF]);
            builder.append(_hexDigits[i24 & 0xF]);
        } else if (i24 >= 256) {
            builder.append("000");
            builder.append(_hexDigits[i24 >> 8 & 0xF]);
            builder.append(_hexDigits[i24 >> 4 & 0xF]);
            builder.append(_hexDigits[i24 & 0xF]);
        } else if (i24 >= 16) {
            builder.append("0000");
            builder.append(_hexDigits[i24 >> 4 & 0xF]);
            builder.append(_hexDigits[i24 & 0xF]);
        } else if (i24 >= 1) {
            builder.append("00000");
            builder.append(_hexDigits[i24 & 0xF]);
        } else {
            builder.append("000000");
        }
    }

    public static StringBuilder toHexFixed(long val, StringBuilder sb) {
        if (sb == null) {
            sb = new StringBuilder(16);
        }
        int i32 = (int)(val >> 32 & 0xFFFFFFFFFFFFFFFFL);
        Hex.toHexFixed(i32, sb);
        i32 = (int)(val & 0xFFFFFFFFFFFFFFFFL);
        Hex.toHexFixed(i32, sb);
        return sb;
    }

    public static StringBuilder toHexFixed(short val, StringBuilder sb) {
        if (sb == null) {
            sb = new StringBuilder(4);
        }
        if (val < 0 || val >= 4096) {
            sb.append(_hexDigits[val >> 12 & 0xF]);
            sb.append(_hexDigits[val >> 8 & 0xF]);
            sb.append(_hexDigits[val >> 4 & 0xF]);
            sb.append(_hexDigits[val & 0xF]);
        } else if (val >= 256) {
            sb.append('0');
            sb.append(_hexDigits[val >> 8 & 0xF]);
            sb.append(_hexDigits[val >> 4 & 0xF]);
            sb.append(_hexDigits[val & 0xF]);
        } else if (val >= 16) {
            sb.append("00");
            sb.append(_hexDigits[val >> 4 & 0xF]);
            sb.append(_hexDigits[val & 0xF]);
        } else if (val >= 1) {
            sb.append("000");
            sb.append(_hexDigits[val & 0xF]);
        } else {
            sb.append("0000");
        }
        return sb;
    }

    public static StringBuilder toHexFixed(byte val, StringBuilder sb) {
        sb.append(_hexDigits[val >> 4 & 0xF]);
        sb.append(_hexDigits[val & 0xF]);
        return sb;
    }

    public static String toHex64(long val) {
        if (0L == val) {
            return "0000000000000000";
        }
        return Hex.toHexFixed(val, new StringBuilder(16)).toString();
    }

    public static String toHex32(int val) {
        if (val == 0) {
            return "00000000";
        }
        return Hex.toHexFixed(val, new StringBuilder(8)).toString();
    }

    public static String toHex16(short val) {
        if (val == 0) {
            return "0000";
        }
        return Hex.toHexFixed(val, new StringBuilder(4)).toString();
    }

    public static StringBuilder toHex(int val, StringBuilder sb) {
        if (val < 0 || val >= 0x10000000) {
            sb.append(_hexDigits[val >> 28 & 0xF]);
            sb.append(_hexDigits[val >> 24 & 0xF]);
            sb.append(_hexDigits[val >> 20 & 0xF]);
            sb.append(_hexDigits[val >> 16 & 0xF]);
            sb.append(_hexDigits[val >> 12 & 0xF]);
            sb.append(_hexDigits[val >> 8 & 0xF]);
            sb.append(_hexDigits[val >> 4 & 0xF]);
            sb.append(_hexDigits[val & 0xF]);
        } else if (val >= 0x1000000) {
            sb.append(_hexDigits[val >> 24 & 0xF]);
            sb.append(_hexDigits[val >> 20 & 0xF]);
            sb.append(_hexDigits[val >> 16 & 0xF]);
            sb.append(_hexDigits[val >> 12 & 0xF]);
            sb.append(_hexDigits[val >> 8 & 0xF]);
            sb.append(_hexDigits[val >> 4 & 0xF]);
            sb.append(_hexDigits[val & 0xF]);
        } else if (val >= 0x100000) {
            sb.append(_hexDigits[val >> 20 & 0xF]);
            sb.append(_hexDigits[val >> 16 & 0xF]);
            sb.append(_hexDigits[val >> 12 & 0xF]);
            sb.append(_hexDigits[val >> 8 & 0xF]);
            sb.append(_hexDigits[val >> 4 & 0xF]);
            sb.append(_hexDigits[val & 0xF]);
        } else if (val >= 65536) {
            sb.append(_hexDigits[val >> 16 & 0xF]);
            sb.append(_hexDigits[val >> 12 & 0xF]);
            sb.append(_hexDigits[val >> 8 & 0xF]);
            sb.append(_hexDigits[val >> 4 & 0xF]);
            sb.append(_hexDigits[val & 0xF]);
        } else if (val >= 4096) {
            sb.append(_hexDigits[val >> 12 & 0xF]);
            sb.append(_hexDigits[val >> 8 & 0xF]);
            sb.append(_hexDigits[val >> 4 & 0xF]);
            sb.append(_hexDigits[val & 0xF]);
        } else if (val >= 256) {
            sb.append(_hexDigits[val >> 8 & 0xF]);
            sb.append(_hexDigits[val >> 4 & 0xF]);
            sb.append(_hexDigits[val & 0xF]);
        } else if (val >= 16) {
            sb.append(_hexDigits[val >> 4 & 0xF]);
            sb.append(_hexDigits[val & 0xF]);
        } else if (val >= 1) {
            sb.append(_hexDigits[val & 0xF]);
        } else {
            sb.append("0");
            return sb;
        }
        return sb;
    }

    public static String toHex(int val) {
        return Hex.toHex(val, new StringBuilder(8)).toString();
    }

    public static StringBuilder toHex(long val, StringBuilder sb) {
        int i32 = (int)(val >> 32 & 0xFFFFFFFFFFFFFFFFL);
        if (i32 != 0) {
            Hex.toHex(i32, sb);
            i32 = (int)(val & 0xFFFFFFFFFFFFFFFFL);
            Hex.toHexFixed(i32, sb);
            return sb;
        }
        i32 = (int)(val & 0xFFFFFFFFFFFFFFFFL);
        Hex.toHex(i32, sb);
        return sb;
    }

    public static String toHex(long val) {
        return Hex.toHex(val, new StringBuilder(16)).toString();
    }

    public static Appendable toHexFixed(short val, Appendable sb) throws IOException {
        if (val < 0 || val >= 4096) {
            sb.append(_hexDigits[val >> 12 & 0xF]);
            sb.append(_hexDigits[val >> 8 & 0xF]);
            sb.append(_hexDigits[val >> 4 & 0xF]);
            sb.append(_hexDigits[val & 0xF]);
        } else if (val >= 256) {
            sb.append('0');
            sb.append(_hexDigits[val >> 8 & 0xF]);
            sb.append(_hexDigits[val >> 4 & 0xF]);
            sb.append(_hexDigits[val & 0xF]);
        } else if (val >= 16) {
            sb.append("00");
            sb.append(_hexDigits[val >> 4 & 0xF]);
            sb.append(_hexDigits[val & 0xF]);
        } else if (val >= 1) {
            sb.append("000");
            sb.append(_hexDigits[val & 0xF]);
        } else {
            sb.append("0000");
        }
        return sb;
    }

    public static int parseHex32(CharSequence hex) throws NumberFormatException {
        if (hex == null) {
            throw new NumberFormatException("For input string: is null!");
        }
        int len = hex.length();
        if (len == 0 || len > 8) {
            throw new NumberFormatException("For input string: \"" + hex + "\"");
        }
        int i = len - 1;
        while (i >= 0) {
            char ch = hex.charAt(i);
            if (ch < '\u0000' || ch >= _hexTable0_f.length || -1 == _hexTable0_f[ch]) {
                throw new NumberFormatException("Invalid HEX char '" + ch + "' at " + (1 + i));
            }
            --i;
        }
        return Hex.parseHex(hex, len);
    }

    public static int parseHex(CharSequence hex, int len) {
        return Hex.parseHex(hex, len, 0);
    }

    public static int parseHex(CharSequence hex, int offset, int end, int invaild) {
        if (end > hex.length()) {
            return invaild;
        }
        if (-1 == end) {
            end = hex.length();
        }
        if (end == 0 || end - offset > 8) {
            return invaild;
        }
        int val = 0;
        int i = offset;
        while (i < end) {
            char ch = hex.charAt(i);
            if (ch < '\u0000' || ch >= _hexTable0_f.length || -1 == _hexTable0_f[ch]) {
                return invaild;
            }
            int bit4 = _hexTable0_f[ch];
            if (i > 0) {
                val <<= 4;
            }
            val |= bit4;
            ++i;
        }
        return val;
    }

    public static int parseHex(CharSequence hex, int len, int invaild) {
        return Hex.parseHex(hex, 0, len, invaild);
    }
}

