/*
 * Decompiled with CFR 0.152.
 */
package cn.weforward.common.io;

import cn.weforward.common.io.InputStreamNio;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;

public class ByteBufferInputStream
extends InputStream
implements InputStreamNio {
    ByteBuffer m_Buffer;

    public ByteBufferInputStream(ByteBuffer buffer) {
        this.m_Buffer = buffer;
    }

    @Override
    public int read(ByteBuffer dst) throws IOException {
        int rem = this.m_Buffer.remaining();
        if (rem <= 0) {
            return -1;
        }
        int drem = dst.remaining();
        if (drem <= 0) {
            return 0;
        }
        int limit = this.m_Buffer.limit();
        if (rem > drem) {
            this.m_Buffer.limit(this.m_Buffer.position() + drem);
            rem = drem;
        }
        dst.put(this.m_Buffer);
        this.m_Buffer.limit(limit);
        return rem;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        int rem = this.m_Buffer.remaining();
        if (rem <= 0) {
            return -1;
        }
        if (len > rem) {
            len = rem;
        }
        this.m_Buffer.get(b, off, len);
        return len;
    }

    @Override
    public int read() throws IOException {
        if (this.m_Buffer.hasRemaining()) {
            return this.m_Buffer.get();
        }
        return -1;
    }

    @Override
    public InputStreamNio duplicate() throws IOException {
        throw new IOException("\u4e0d\u652f\u6301");
    }
}

