/*
 * Decompiled with CFR 0.152.
 */
package cn.weforward.common.io;

import cn.weforward.common.io.InputStreamNio;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;

public class BytesInputStream
extends ByteArrayInputStream
implements InputStreamNio {
    private static InputStream _empty = new InputStream(){

        @Override
        public int read() throws IOException {
            return -1;
        }
    };

    public BytesInputStream(byte[] buf) {
        super(buf);
    }

    public BytesInputStream(byte[] buf, int offset, int length) {
        super(buf, offset, length);
    }

    @Override
    public int read(ByteBuffer dst) throws IOException {
        int count = 0;
        while (dst.hasRemaining()) {
            dst.put((byte)this.read());
            ++count;
        }
        return count;
    }

    @Override
    public InputStreamNio duplicate() throws IOException {
        return new BytesInputStream(this.buf, this.pos, this.count - this.pos);
    }

    public static InputStream empty() {
        return _empty;
    }
}

