/*
 * Decompiled with CFR 0.152.
 */
package cn.weforward.common.io;

import cn.weforward.common.io.CachedInputStream;
import cn.weforward.common.io.InputStreamNio;
import cn.weforward.common.io.OutputStreamNio;
import cn.weforward.common.util.Bytes;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.WritableByteChannel;
import java.util.Arrays;

public class BytesOutputStream
extends ByteArrayOutputStream
implements OutputStreamNio {
    public static final byte[] _emptyBytes = new byte[0];

    public BytesOutputStream() {
    }

    public BytesOutputStream(int size) {
        super(size);
    }

    private BytesOutputStream(CachedInputStream.AtBuffers buffers) {
        super(buffers.size());
        this.buf = buffers.toArray(this.buf, 0);
        this.count = buffers.size();
    }

    public BytesOutputStream(InputStream in) throws IOException {
        this(new CachedInputStream.AtBuffers(in, 0));
        in.close();
    }

    public synchronized byte[] detach() {
        byte[] bs;
        if (this.count < this.buf.length) {
            bs = Arrays.copyOf(this.buf, this.count);
        } else {
            bs = this.buf;
            this.buf = _emptyBytes;
        }
        this.count = 0;
        return bs;
    }

    public Bytes getBytes() {
        if (this.count == 0) {
            return Bytes.empty();
        }
        return new Bytes(this.buf, 0, this.count);
    }

    public InputStream detachStream() throws IOException {
        ByteArrayInputStream in = new ByteArrayInputStream(this.buf, 0, this.count);
        this.buf = _emptyBytes;
        this.count = 0;
        return in;
    }

    public synchronized void setSize(int length) throws IOException {
        if (length > this.count || length >= this.buf.length) {
            throw new EOFException("length\u8d8a\u754c{" + this.count + ";" + this.buf.length + "}");
        }
        this.count = length;
    }

    @Override
    public synchronized int write(InputStream src) throws IOException {
        int ret;
        do {
            int len;
            if ((len = src.available()) < 2) {
                len = 512;
            }
            this.ensureWritableBytes(len);
            ret = src.read(this.buf, this.count, len);
            if (ret <= 0) continue;
            this.count += ret;
        } while (-1 != ret);
        return 0;
    }

    @Override
    public synchronized int write(ByteBuffer src) throws IOException {
        int len = src.remaining();
        this.ensureWritableBytes(len);
        src.get(this.buf, this.count, len);
        this.count += len;
        return len;
    }

    @Override
    public void cancel() throws IOException {
        this.reset();
    }

    protected void ensureWritableBytes(int minSize) {
        if (minSize > this.buf.length - this.count) {
            int grow = this.buf.length << 1;
            if (grow < minSize + this.count) {
                grow = minSize + this.count;
            }
            byte[] copy = new byte[grow];
            System.arraycopy(this.buf, 0, copy, 0, this.count);
            this.buf = copy;
        }
    }

    public static int transfer(InputStream in, OutputStream out, int limit) throws IOException {
        if (limit <= 0) {
            if (in instanceof InputStreamNio && out instanceof OutputStreamNio) {
                OutputStreamNio outNio = (OutputStreamNio)((Object)out);
                InputStreamNio inNio = (InputStreamNio)((Object)in);
                ByteBuffer buf = ByteBuffer.allocateDirect(512);
                int total = 0;
                while (true) {
                    buf.clear();
                    int ret = inNio.read(buf);
                    if (ret < 0) break;
                    buf.flip();
                    if (ret != buf.remaining()) {
                        throw new IOException("ret!=remaining ??");
                    }
                    outNio.write(buf);
                    total += ret;
                }
                return total;
            }
            if (in instanceof FileInputStream && out instanceof WritableByteChannel) {
                FileChannel channel = ((FileInputStream)in).getChannel();
                long size = channel.size();
                channel.transferTo(0L, size, (WritableByteChannel)((Object)out));
                return (int)(Integer.MAX_VALUE & size);
            }
        }
        int total = 0;
        byte[] buf = (byte[])Bytes.Pool._8k.poll();
        try {
            int len;
            if (limit <= 0) {
                int len2;
                do {
                    if ((len2 = in.read(buf)) <= 0) continue;
                    out.write(buf, 0, len2);
                    total += len2;
                } while (len2 >= 0);
                int n = total;
                return n;
            }
            do {
                if ((len = limit - total) > buf.length) {
                    len = buf.length;
                }
                if ((len = in.read(buf, 0, len)) <= 0) continue;
                out.write(buf, 0, len);
                total += len;
            } while (len >= 0 && total < limit);
            int n = total;
            return n;
        }
        finally {
            Bytes.Pool._8k.offer(buf);
        }
    }

    public static int transfer(ByteBuffer buffer, OutputStream out, int limit) throws IOException {
        int total = 0;
        if (out instanceof OutputStreamNio) {
            OutputStreamNio outNio = (OutputStreamNio)((Object)out);
            total = buffer.remaining();
            if (limit > 0 && limit < total) {
                total = limit;
                limit = buffer.limit();
                buffer.limit(total + buffer.position());
                outNio.write(buffer);
                buffer.limit(limit);
            } else {
                outNio.write(buffer);
            }
            return total;
        }
        byte[] buf = (byte[])Bytes.Pool._8k.poll();
        try {
            if (limit <= 0) {
                int remain = buffer.remaining();
                while (remain > 0) {
                    int len = buf.length > remain ? remain : buf.length;
                    buffer.get(buf, 0, len);
                    out.write(buf, 0, len);
                    total += len;
                    remain = buffer.remaining();
                }
                int n = total;
                return n;
            }
            int remain = buffer.remaining();
            while (remain > 0 && limit < total) {
                int len = limit - total;
                if (len > buf.length) {
                    len = buf.length;
                }
                if (len > remain) {
                    len = remain;
                }
                buffer.get(buf, 0, len);
                out.write(buf, 0, len);
                total += len;
                remain = buffer.remaining();
            }
            int n = total;
            return n;
        }
        finally {
            Bytes.Pool._8k.offer(buf);
        }
    }
}

