/*
 * Decompiled with CFR 0.152.
 */
package cn.weforward.common.io;

import cn.weforward.common.execption.OverflowException;
import cn.weforward.common.util.Bytes;
import cn.weforward.common.util.StringUtil;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class CachedInputStream
extends InputStream {
    protected InputStream m_Origin;
    protected int m_Count;
    protected int m_Pos;
    protected int mark;
    protected byte[] m_Cache;

    public static InputStream cached(InputStream in) {
        if (in.markSupported()) {
            return in;
        }
        return new CachedInputStream(in);
    }

    public CachedInputStream(InputStream in) {
        this.m_Origin = in;
    }

    private int expand(int size) {
        int c;
        if (this.m_Cache == null) {
            c = size;
            this.m_Cache = new byte[c];
        } else {
            c = this.m_Cache.length - this.m_Count;
            if (c <= 0) {
                c = size;
                this.m_Cache = Arrays.copyOf(this.m_Cache, c + this.m_Count);
            }
        }
        return c;
    }

    private void capacity(int size) {
        if (this.m_Cache == null) {
            this.m_Cache = new byte[size];
            return;
        }
        int c = this.m_Cache.length - this.m_Count;
        if (c < size) {
            c = size - c;
            this.m_Cache = Arrays.copyOf(this.m_Cache, c + this.m_Count);
        }
    }

    private int cache(int len) throws IOException {
        if (this.m_Origin == null) {
            return -1;
        }
        if (Thread.currentThread().isInterrupted()) {
            throw new InterruptedIOException(String.valueOf(this.m_Origin));
        }
        if (1 == len) {
            int single = this.m_Origin.read();
            if (-1 == single) {
                return -1;
            }
            if (this.expand(1) < 1) {
                throw new IOException("\u6269\u5c55\u7f13\u5b58\u5bb9\u91cf\u5931\u8d25");
            }
            this.m_Cache[this.m_Count++] = (byte)single;
            return 1;
        }
        int c = this.expand(len);
        if ((c = this.m_Origin.read(this.m_Cache, this.m_Count, c)) < 0) {
            this.m_Origin.close();
            this.m_Origin = null;
        } else {
            this.m_Count += c;
        }
        return c;
    }

    private int cacheFully(int len) throws IOException {
        if (this.m_Origin == null) {
            return -1;
        }
        this.capacity(len);
        int total = len;
        while (len > 0) {
            int n = this.m_Origin.read(this.m_Cache, this.m_Count, len);
            if (n <= 0) break;
            this.m_Count += n;
            len -= n;
        }
        return total - len;
    }

    public int count() {
        return this.m_Count;
    }

    public int position() {
        return this.m_Pos;
    }

    public void position(int pos) {
        if (pos < 0 || pos > this.m_Count) {
            throw new IndexOutOfBoundsException("pos[" + pos + "]{0~" + this.m_Count + "}");
        }
        this.m_Pos = pos;
    }

    @Override
    public synchronized int read() throws IOException {
        if (this.m_Pos >= this.m_Count && this.cache(4096) < 1) {
            return -1;
        }
        return this.m_Cache[this.m_Pos++];
    }

    @Override
    public synchronized int read(byte[] b, int off, int len) throws IOException {
        int total = 0;
        while (len > 0) {
            int c = this.m_Count - this.m_Pos;
            if (c <= 0) {
                c = this.cache(len < 4096 ? 4096 : len);
                if (-1 == c && total == 0) {
                    return -1;
                }
                if (c < 1) {
                    return total;
                }
            }
            if (c > len) {
                c = len;
            }
            System.arraycopy(this.m_Cache, this.m_Pos, b, off, c);
            len -= c;
            off += c;
            this.m_Pos += c;
            total += c;
        }
        return total;
    }

    @Override
    public synchronized long skip(long n) throws IOException {
        if (n > Integer.MAX_VALUE) {
            throw new EOFException("\u6ca1\u6709\u8fd9\u4e48\u591a\u6570\u636e\uff1a" + n);
        }
        int nn = (int)(Integer.MAX_VALUE & n);
        int c = this.m_Count - this.m_Pos;
        if (c < 1 && (c = this.cache(nn)) < 1) {
            return -1L;
        }
        if (c > nn) {
            c = nn;
        }
        this.m_Pos += c;
        return c;
    }

    @Override
    public int available() throws IOException {
        if (this.m_Origin == null) {
            return this.m_Count - this.m_Pos;
        }
        return this.m_Origin.available() + (this.m_Count - this.m_Pos);
    }

    public boolean isEof() {
        return this.m_Origin == null;
    }

    @Override
    public void close() throws IOException {
        InputStream origin = this.m_Origin;
        if (origin != null) {
            this.m_Origin = null;
            origin.close();
        }
    }

    @Override
    public synchronized void mark(int readlimit) {
        this.mark = this.m_Pos;
    }

    @Override
    public synchronized void reset() throws IOException {
        this.m_Pos = this.mark;
    }

    @Override
    public boolean markSupported() {
        return true;
    }

    public synchronized void fullyCached() throws IOException {
        if (this.m_Origin == null) {
            return;
        }
        AtBuffers buffers = new AtBuffers(this.m_Origin, 0);
        int count = this.count();
        this.expand(buffers.size() + count);
        this.m_Cache = buffers.toArray(this.m_Cache, count);
        this.m_Count = buffers.size() + count;
        this.close();
    }

    public Bytes getBytes() {
        if (this.m_Count < 1) {
            return Bytes.empty();
        }
        return new Bytes(this.m_Cache, this.m_Pos, this.m_Count);
    }

    public byte[] getFitBytes() {
        if (this.m_Pos == 0 && this.m_Count == this.m_Cache.length) {
            return this.m_Cache;
        }
        return Arrays.copyOfRange(this.m_Cache, this.m_Pos, this.m_Count + this.m_Pos);
    }

    public static Bytes toBytes(InputStream in) throws IOException {
        return CachedInputStream.toBytes(in, 0);
    }

    public static Bytes toBytes(InputStream in, int limit) throws IOException {
        AtBuffers buffers = new AtBuffers(in, limit);
        Bytes bytes = new Bytes(buffers.toArray());
        in.close();
        return bytes;
    }

    public static String readString(InputStream in, int expect, String charset) throws IOException {
        return CachedInputStream.readString(in, expect, 0, charset);
    }

    public static String readString(InputStream in, int expect, int limit, String charset) throws IOException {
        int count;
        int offset;
        byte[] data;
        if (in == null) {
            return null;
        }
        if (in instanceof CachedInputStream) {
            CachedInputStream cached = (CachedInputStream)in;
            if (expect > 0) {
                if (cached.cacheFully(expect) >= expect) {
                    if (limit > 0 && cached.cacheFully(limit) >= limit) {
                        cached.close();
                        throw new OverflowException("\u8981\u8bfb\u53d6\u7684\u6570\u636e\u91cf\u8d85\u8fc7\u9650\u5236[" + limit + "]");
                    }
                    cached.fullyCached();
                }
            } else {
                cached.fullyCached();
            }
            cached.close();
            data = cached.m_Cache;
            offset = cached.m_Pos;
            count = cached.m_Count;
        } else {
            AtBuffers ab = new AtBuffers();
            ab.input(in, limit);
            in.close();
            data = ab.toArray();
            count = data.length;
            offset = 0;
        }
        if (count == 0) {
            return "";
        }
        if (charset == null) {
            charset = StringUtil.isUtf8(data, offset, count) ? "UTF-8" : "GBK";
        }
        String str = new String(data, offset, count, charset);
        return str;
    }

    public static boolean isUtf8(byte[] bytes, int len) {
        return StringUtil.isUtf8(bytes, 0, len);
    }

    public static int readFully(InputStream in, byte[] buffer, int off, int len) throws IOException {
        int total = len;
        while (len > 0) {
            int n = in.read(buffer, off, len);
            if (n < 0) break;
            off += n;
            len -= n;
        }
        return total - len;
    }

    public static int copy(InputStream in, OutputStream out) throws IOException {
        int total = 0;
        byte[] buf = (byte[])Bytes.Pool._8k.poll();
        try {
            int ret;
            do {
                if ((ret = in.read(buf)) <= 0) continue;
                out.write(buf, 0, ret);
                total += ret;
            } while (ret >= 0);
        }
        finally {
            Bytes.Pool._8k.offer(buf);
            in.close();
        }
        return total;
    }

    public static class AtBuffers {
        int m_Count;
        List<byte[]> m_Buffers = new LinkedList<byte[]>();
        byte[] m_Bytes;

        public AtBuffers() {
        }

        public AtBuffers(InputStream in, int limit) throws IOException {
            this();
            boolean fail = true;
            try {
                this.input(in, limit);
                fail = false;
            }
            finally {
                if (fail) {
                    this.free();
                }
            }
        }

        public int input(InputStream in, int limit) throws IOException {
            int ret;
            byte[] buf = (byte[])Bytes.Pool._8k.poll();
            this.m_Buffers.add(buf);
            int len = buf.length;
            int offset = 0;
            if (limit <= 0) {
                limit = Integer.MAX_VALUE;
            }
            int count = 0;
            do {
                int remain;
                if (len <= 0) {
                    buf = (byte[])Bytes.Pool._8k.poll();
                    this.m_Buffers.add(buf);
                    len = buf.length;
                    offset = 0;
                }
                if (len > (remain = limit - count)) {
                    len = remain;
                }
                if ((ret = in.read(buf, offset, len)) <= 0) continue;
                count += ret;
                offset += ret;
                len -= ret;
            } while (ret >= 0 && count < limit);
            this.m_Count += count;
            return count;
        }

        public int size() {
            return this.m_Count;
        }

        public byte[] toArray() {
            if (this.m_Bytes != null) {
                return this.m_Bytes;
            }
            this.m_Bytes = new byte[this.size()];
            return this.toArray(this.m_Bytes, 0);
        }

        public byte[] toArray(byte[] bs, int offset) {
            int size = bs.length - offset;
            if (size < this.size()) {
                bs = Arrays.copyOf(bs, offset + this.size());
            }
            Iterator<byte[]> it = this.m_Buffers.iterator();
            while (it.hasNext() && offset < size) {
                int len = size - offset;
                byte[] buf = it.next();
                if (len > buf.length) {
                    len = buf.length;
                }
                System.arraycopy(buf, 0, bs, offset, len);
                offset += len;
            }
            this.free();
            return bs;
        }

        private void free() {
            if (this.m_Buffers == null) {
                return;
            }
            Iterator<byte[]> it = this.m_Buffers.iterator();
            while (it.hasNext()) {
                Bytes.Pool._8k.offer(it.next());
            }
            this.m_Buffers = null;
        }

        public void close() {
            this.free();
            this.m_Bytes = null;
            this.m_Count = 0;
        }
    }
}

