/*
 * Decompiled with CFR 0.152.
 */
package cn.weforward.common.io;

import cn.weforward.common.io.StayException;
import java.io.Flushable;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;

public interface OutputStreamStay
extends Flushable {
    public void stay() throws StayException;

    public static class Wrap
    extends OutputStream
    implements OutputStreamStay {
        protected OutputStream m_Out;
        protected byte[] m_Buffer;
        protected int m_Count;

        public static OutputStream wrap(OutputStream out) {
            if (out instanceof OutputStreamStay) {
                return out;
            }
            return new Wrap(out);
        }

        public Wrap(OutputStream out) {
            this.m_Out = out;
        }

        private void ensureCapacity(int minCapacity) {
            int oldCapacity = 0;
            if (this.m_Buffer != null) {
                oldCapacity = this.m_Buffer.length;
            }
            if (minCapacity > oldCapacity) {
                int newCapacity;
                int n = newCapacity = oldCapacity > 8192 ? 4096 : oldCapacity * 2;
                if (newCapacity < minCapacity) {
                    newCapacity = minCapacity;
                }
                this.m_Buffer = this.m_Buffer == null ? new byte[newCapacity] : Arrays.copyOf(this.m_Buffer, newCapacity);
            }
        }

        private boolean isFlushed() {
            return this.m_Count < 0;
        }

        protected void flushBuffer() throws IOException {
            if (this.m_Count > 0) {
                this.m_Out.write(this.m_Buffer, 0, this.m_Count);
            }
            this.m_Count = -1;
        }

        @Override
        public void stay() throws StayException {
            if (this.isFlushed()) {
                throw new StayException("\u5df2\u5237\u5199\u8fc7");
            }
        }

        @Override
        public void write(int b) throws IOException {
            if (this.isFlushed()) {
                this.write(b);
                return;
            }
            this.ensureCapacity(this.m_Count + 1);
            this.m_Buffer[this.m_Count] = (byte)b;
            ++this.m_Count;
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
            if (this.isFlushed()) {
                this.write(b, off, len);
                return;
            }
            if (off < 0 || off > b.length || len < 0 || off + len - b.length > 0) {
                throw new IndexOutOfBoundsException();
            }
            this.ensureCapacity(this.m_Count + len);
            System.arraycopy(b, off, this.m_Buffer, this.m_Count, len);
            this.m_Count += len;
        }

        @Override
        public void flush() throws IOException {
            this.flushBuffer();
            super.flush();
        }

        @Override
        public void close() throws IOException {
            this.flushBuffer();
            this.m_Out.close();
        }
    }
}

