/*
 * Decompiled with CFR 0.152.
 */
package cn.weforward.common.json;

import cn.weforward.common.io.InputStreamNio;
import cn.weforward.common.json.JsonInput;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CoderResult;
import java.nio.charset.StandardCharsets;

public class JsonInputStream
implements JsonInput {
    protected InputStream m_Source;
    protected CharsetDecoder m_Decoder;
    protected ByteBuffer m_InBuffer;
    protected CharBuffer m_OutBuffer;
    protected int m_Position;

    public JsonInputStream(InputStream source) {
        this(source, "UTF-8");
    }

    public JsonInputStream(InputStream source, String charset) {
        this.m_Source = source;
        Charset cs = Charset.forName(charset);
        this.m_Decoder = cs.newDecoder();
    }

    protected boolean decode() throws IOException {
        byte[] bytes;
        int pos;
        if (this.m_Source == null) {
            throw new IOException("closed.");
        }
        if (this.m_OutBuffer == null) {
            this.m_InBuffer = ByteBuffer.allocate(24 * (int)this.m_Decoder.averageCharsPerByte());
            this.m_InBuffer.rewind();
            this.m_InBuffer.limit(0);
            this.m_OutBuffer = CharBuffer.allocate(this.m_InBuffer.capacity());
            this.m_OutBuffer.rewind();
            this.m_OutBuffer.limit(0);
        } else if (this.m_OutBuffer.hasRemaining()) {
            return true;
        }
        if (this.m_InBuffer.remaining() == 0) {
            this.m_InBuffer.clear();
            pos = 0;
        } else if (this.m_InBuffer.limit() == this.m_InBuffer.capacity()) {
            bytes = this.m_InBuffer.array();
            pos = this.m_InBuffer.remaining();
            System.arraycopy(bytes, this.m_InBuffer.arrayOffset() + this.m_InBuffer.position(), bytes, 0, pos);
            this.m_InBuffer.position(pos);
            this.m_InBuffer.limit(this.m_InBuffer.capacity());
            pos = 0;
        } else {
            pos = this.m_InBuffer.position();
            this.m_InBuffer.position(this.m_InBuffer.limit());
            this.m_InBuffer.limit(this.m_InBuffer.capacity());
        }
        if (this.m_Source instanceof InputStreamNio) {
            if (((InputStreamNio)((Object)this.m_Source)).read(this.m_InBuffer) < 0) {
                return false;
            }
            this.m_InBuffer.flip();
        } else {
            bytes = this.m_InBuffer.array();
            int len = this.m_Source.read(bytes, this.m_InBuffer.arrayOffset() + this.m_InBuffer.position(), this.m_InBuffer.remaining());
            if (len < 0) {
                return false;
            }
            this.m_InBuffer.limit(len + this.m_InBuffer.position());
        }
        this.m_InBuffer.position(pos);
        this.m_OutBuffer.clear();
        CoderResult cr = this.m_Decoder.decode(this.m_InBuffer, this.m_OutBuffer, false);
        if (!cr.isUnderflow()) {
            cr.throwException();
        }
        this.m_OutBuffer.flip();
        return true;
    }

    @Override
    public int available() throws IOException {
        if (this.m_OutBuffer != null && this.m_OutBuffer.remaining() > 0) {
            return this.m_OutBuffer.remaining();
        }
        return this.m_Source.available();
    }

    @Override
    public char readChar() throws IOException {
        if (!this.decode()) {
            throw new EOFException();
        }
        char ch = this.m_OutBuffer.get();
        this.m_Position = StandardCharsets.UTF_8 == this.m_Decoder.charset() ? (ch >= '\u0000' && ch <= '\u007f' ? ++this.m_Position : (ch >= '\u0080' && ch <= '\u07ff' ? (this.m_Position += 2) : (ch >= '\u0800' && ch <= '\ud7ff' ? (this.m_Position += 3) : (ch >= '\ud800' && ch <= '\udfff' ? (this.m_Position += 2) : (this.m_Position += 3))))) : ++this.m_Position;
        return ch;
    }

    @Override
    public int position() {
        return this.m_Position;
    }

    @Override
    public void close() throws IOException {
        this.m_Decoder = null;
        this.m_InBuffer = null;
        this.m_OutBuffer = null;
        this.m_Source.close();
        this.m_Source = null;
    }
}

