/*
 * Decompiled with CFR 0.152.
 */
package cn.weforward.common.json;

import cn.weforward.common.crypto.Hex;
import cn.weforward.common.execption.InvalidFormatException;
import cn.weforward.common.json.JsonArray;
import cn.weforward.common.json.JsonInput;
import cn.weforward.common.json.JsonNode;
import cn.weforward.common.json.JsonObject;
import cn.weforward.common.json.JsonOutput;
import cn.weforward.common.json.JsonPair;
import cn.weforward.common.json.JsonParseAbort;
import cn.weforward.common.json.SimpleJsonArray;
import cn.weforward.common.json.SimpleJsonObject;
import cn.weforward.common.util.StringBuilderPool;
import cn.weforward.common.util.StringPool;
import java.io.IOException;

public class JsonUtil {
    public static StringPool _NamePool = new StringPool(2048);
    protected static StringBuilderPool _NameBuilderPool = new StringBuilderPool(1024, 100);
    static NodeBuilder DEFAULT_BUILDER = new NodeBuilder(){

        @Override
        public JsonObject.Appendable createObject() {
            return new SimpleJsonObject();
        }

        @Override
        public JsonArray.Appendable createArray() {
            return new SimpleJsonArray();
        }

        @Override
        public JsonObject emptyObject() {
            return SimpleJsonObject.empty();
        }

        @Override
        public JsonArray emptyArray() {
            return SimpleJsonArray.empty();
        }
    };
    static Listener _unassigned = new Listener(){

        @Override
        public void foundNode(JsonNode value, String name, int depth) {
        }
    };

    public static JsonNode parse(JsonInput in, Listener listener) throws IOException {
        return JsonUtil.parse(in, listener, DEFAULT_BUILDER);
    }

    public static JsonNode parse(JsonInput in, Listener listener, NodeBuilder builder) throws IOException {
        char ch = JsonUtil.skipBlank(in, 100);
        JsonNode ret = null;
        if ('{' == ch) {
            Context ctx = new Context(in, listener);
            ret = JsonUtil.parseObject(ctx, builder);
        } else if ('[' == ch) {
            Context ctx = new Context(in, listener);
            ret = JsonUtil.parseArray(ctx, builder);
        }
        if (ret != null) {
            if (listener != null) {
                listener.foundNode(ret, null, 0);
            }
            return ret;
        }
        throw JsonUtil.illegalFormat(in, "JSON\u683c\u5f0f\u6709\u8bef");
    }

    private static Object parseValue(Context ctx, String name, NodeBuilder builder) throws IOException {
        StringBuilder valueBuilder = StringBuilderPool._8k.poll();
        try {
            char ch;
            char first;
            if ('\uffff' != ctx.remainChar) {
                ch = first = ctx.remainChar;
                ctx.remainChar = '\uffff';
            } else {
                ch = first = JsonUtil.skipBlank(ctx.in, 100);
            }
            if ('\"' == first || '\'' == first) {
                while (true) {
                    if ('\\' == (ch = ctx.in.readChar())) {
                        JsonUtil.unescape(ctx.in, valueBuilder);
                        continue;
                    }
                    if (first != '\u0000' && first == ch) break;
                    valueBuilder.append(ch);
                }
                String string = valueBuilder.toString();
                return string;
            }
            if ('{' == first) {
                JsonObject ret = JsonUtil.parseObject(ctx, builder);
                ctx.listener.foundNode(ret, name, ctx.depth);
                JsonObject jsonObject = ret;
                return jsonObject;
            }
            if ('[' == first) {
                JsonArray ret = JsonUtil.parseArray(ctx, builder);
                ctx.listener.foundNode(ret, name, ctx.depth);
                JsonArray jsonArray = ret;
                return jsonArray;
            }
            while (' ' != ch && '\r' != ch && '\n' != ch) {
                if (',' == ch || '}' == ch || ']' == ch) {
                    ctx.remainChar = ch;
                    break;
                }
                valueBuilder.append(Character.toLowerCase(ch));
                ch = ctx.in.readChar();
            }
            if (JsonUtil.equalsIgnoreCase(valueBuilder, "true")) {
                Boolean bl = Boolean.TRUE;
                return bl;
            }
            if (JsonUtil.equalsIgnoreCase(valueBuilder, "false")) {
                Boolean bl = Boolean.FALSE;
                return bl;
            }
            if (JsonUtil.equalsIgnoreCase(valueBuilder, "null")) {
                return null;
            }
            String v = valueBuilder.toString();
            if (-1 != v.indexOf(46)) {
                Double d = Double.valueOf(v);
                return d;
            }
            long l = Long.parseLong(v);
            if (l < Integer.MIN_VALUE || l > Integer.MAX_VALUE) {
                Long l2 = l;
                return l2;
            }
            if (l < -32768L || l > 32767L) {
                Integer n = (int)l;
                return n;
            }
            Short s = (short)l;
            return s;
        }
        finally {
            StringBuilderPool._8k.offer(valueBuilder);
        }
    }

    private static JsonObject parseObject(Context ctx, NodeBuilder builder) throws IOException {
        char ch = JsonUtil.skipBlank(ctx.in, 100);
        if ('}' == ch) {
            return builder.emptyObject();
        }
        Context context = ctx;
        context.depth = context.depth + 1;
        JsonObject.Appendable ret = builder.createObject();
        StringBuilder nameBuilder = _NameBuilderPool.poll();
        try {
            while (ctx.in.available() >= 0) {
                nameBuilder.setLength(0);
                char nameQuot = ch;
                if ('\"' != nameQuot && '\'' != nameQuot) {
                    nameBuilder.append(nameQuot);
                    nameQuot = '\u0000';
                }
                while (true) {
                    if ('\\' == (ch = ctx.in.readChar())) {
                        JsonUtil.unescape(ctx.in, nameBuilder);
                        continue;
                    }
                    if (nameQuot == ch) break;
                    if (':' == ch && nameQuot == '\u0000') {
                        JsonUtil.rtrim(nameBuilder);
                        break;
                    }
                    if (nameBuilder.length() == nameBuilder.capacity()) {
                        throw JsonUtil.illegalFormat(ctx.in, "\u540d\u79f0\u8fc7\u957f");
                    }
                    nameBuilder.append(ch);
                }
                String name = _NamePool.intern(nameBuilder);
                while (':' != ch) {
                    ch = ctx.in.readChar();
                }
                Object value = JsonUtil.parseValue(ctx, name, builder);
                ret.add(name, value);
                if ('\uffff' != ctx.remainChar) {
                    ch = ctx.remainChar;
                    ctx.remainChar = '\uffff';
                } else {
                    ch = JsonUtil.skipBlank(ctx.in, 100);
                }
                if (',' == ch) {
                    ch = JsonUtil.skipBlank(ctx.in, 100);
                    continue;
                }
                if ('}' == ch) {
                    break;
                }
                if (']' != ch) continue;
                throw JsonUtil.illegalFormat(ctx.in, "\u4e0d\u662f\u9884\u671f\u7684']'");
            }
        }
        finally {
            _NameBuilderPool.offer(nameBuilder);
        }
        Context context2 = ctx;
        context2.depth = context2.depth - 1;
        return ret;
    }

    private static JsonArray parseArray(Context ctx, NodeBuilder builder) throws IOException {
        char ch = JsonUtil.skipBlank(ctx.in, 100);
        if (']' == ch) {
            return builder.emptyArray();
        }
        ctx.remainChar = ch;
        JsonArray.Appendable ret = builder.createArray();
        Context context = ctx;
        context.depth = context.depth + 1;
        while (ctx.in.available() >= 0) {
            Object value = JsonUtil.parseValue(ctx, null, builder);
            ret.add(value);
            if ('\uffff' != ctx.remainChar) {
                ch = ctx.remainChar;
                ctx.remainChar = '\uffff';
            } else {
                ch = JsonUtil.skipBlank(ctx.in, 100);
            }
            if (',' == ch) continue;
            if (']' == ch) break;
            if ('}' != ch) continue;
            throw JsonUtil.illegalFormat(ctx.in, "\u4e0d\u662f\u9884\u671f\u7684'}'");
        }
        Context context2 = ctx;
        context2.depth = context2.depth - 1;
        return ret;
    }

    public static void format(JsonNode json, JsonOutput out) throws IOException {
        if (json instanceof JsonObject) {
            JsonUtil.formatObject((JsonObject)json, out);
            return;
        }
        JsonUtil.formatArray((JsonArray)json, out);
    }

    private static void formatObject(JsonObject object, JsonOutput out) throws IOException {
        out.append('{');
        boolean first = true;
        for (JsonPair pair : object.items()) {
            if (first) {
                first = false;
            } else {
                out.append(',');
            }
            out.append('\"');
            JsonUtil.escape(pair.getKey(), out);
            out.append('\"');
            out.append(':');
            JsonUtil.formatValue(pair.getValue(), out);
        }
        out.append('}');
    }

    private static void formatArray(JsonArray array, JsonOutput out) throws IOException {
        out.append('[');
        int count = array.size();
        int i = 0;
        while (i < count) {
            if (i > 0) {
                out.append(',');
            }
            JsonUtil.formatValue(array.item(i), out);
            ++i;
        }
        out.append(']');
    }

    private static void formatValue(Object value, JsonOutput out) throws IOException {
        if (value == null) {
            out.append("null");
            return;
        }
        if (value instanceof String) {
            out.append('\"');
            JsonUtil.escape((String)value, out);
            out.append('\"');
            return;
        }
        if (value instanceof Number) {
            Number v = (Number)value;
            out.append(v.toString());
            return;
        }
        if (value instanceof JsonObject) {
            JsonUtil.formatObject((JsonObject)value, out);
            return;
        }
        if (value instanceof JsonArray) {
            JsonUtil.formatArray((JsonArray)value, out);
            return;
        }
        if (value instanceof Boolean) {
            Boolean v = (Boolean)value;
            if (v.booleanValue()) {
                out.append("true");
            } else {
                out.append("false");
            }
            return;
        }
        throw new InvalidFormatException("JSON\u503c\u7c7b\u578b\u4e0d\u652f\u6301" + value);
    }

    private static char toLowerCase(char ch) {
        if (ch <= 'Z' && ch >= 'A') {
            return (char)(ch + 32);
        }
        return ch;
    }

    public static boolean equalsIgnoreCase(CharSequence str1, CharSequence str2) {
        if (str1 == null || str2 == null) {
            return false;
        }
        if (str1 == str2) {
            return true;
        }
        int len = str1.length();
        if (str2.length() != len) {
            return false;
        }
        int i = 0;
        while (i < len) {
            char ch2;
            char ch1 = JsonUtil.toLowerCase(str1.charAt(i));
            if (ch1 != (ch2 = JsonUtil.toLowerCase(str2.charAt(i)))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static void rtrim(StringBuilder builder) {
        int i = builder.length() - 1;
        while (i >= 0 && JsonUtil.isBlank(builder.charAt(i))) {
            --i;
        }
        builder.setLength(i + 1);
    }

    public static char skipBlank(JsonInput in, int limit) throws IOException {
        char ch;
        do {
            if (--limit != 0) continue;
            throw JsonUtil.illegalFormat(in, "\u7a7a\u683c\u53ca\u6362\u884c\u592a\u591a");
        } while (JsonUtil.isBlank(ch = in.readChar()));
        return ch;
    }

    public static final boolean isBlank(char ch) {
        return ' ' == ch || '\t' == ch || '\r' == ch || '\n' == ch;
    }

    private static InvalidFormatException illegalFormat(JsonInput in, String errorMsg) {
        return new InvalidFormatException(String.valueOf(errorMsg) + " " + in);
    }

    private static boolean isEmpty(CharSequence string) {
        return string == null || string.length() == 0;
    }

    public static void escape(CharSequence string, Appendable appender) throws IOException {
        if (JsonUtil.isEmpty(string)) {
            return;
        }
        int i = 0;
        while (i < string.length()) {
            char ch = string.charAt(i);
            switch (ch) {
                case '\"': {
                    appender.append("\\\"");
                    break;
                }
                case '\\': {
                    appender.append("\\\\");
                    break;
                }
                case '/': {
                    appender.append("\\/");
                    break;
                }
                case '\b': {
                    appender.append("\\b");
                    break;
                }
                case '\f': {
                    appender.append("\\f");
                    break;
                }
                case '\n': {
                    appender.append("\\n");
                    break;
                }
                case '\r': {
                    appender.append("\\r");
                    break;
                }
                case '\t': {
                    appender.append("\\t");
                    break;
                }
                default: {
                    if (' ' == ch || '!' == ch || ch >= '#' && ch <= '[' || ch >= ']' || ch < '\u0000') {
                        appender.append(ch);
                        break;
                    }
                    appender.append("\\u");
                    Hex.toHexFixed((short)ch, appender);
                }
            }
            ++i;
        }
    }

    public static Appendable unescape(JsonInput in, Appendable builder) throws IOException {
        char ch = in.readChar();
        switch (ch) {
            case '\"': 
            case '/': 
            case '\\': {
                builder.append(ch);
                break;
            }
            case 'b': {
                builder.append('\b');
                break;
            }
            case 'f': {
                builder.append('\f');
                break;
            }
            case 'n': {
                builder.append('\n');
                break;
            }
            case 'r': {
                builder.append('\r');
                break;
            }
            case 't': {
                builder.append('\t');
                break;
            }
            case 'u': {
                StringBuilder unicode = new StringBuilder(4);
                unicode.append(in.readChar());
                unicode.append(in.readChar());
                unicode.append(in.readChar());
                unicode.append(in.readChar());
                int code = Hex.parseHex(unicode, 4, Integer.MAX_VALUE);
                if (Integer.MAX_VALUE == code) {
                    builder.append("\\u");
                    break;
                }
                builder.append((char)code);
                break;
            }
            default: {
                builder.append('\n').append(ch);
            }
        }
        return builder;
    }

    public static class Context {
        public static final char INVALID_CHAR = '\uffff';
        private JsonInput in;
        private Listener listener;
        private int depth;
        private char remainChar;

        public Context(JsonInput in, Listener listener) {
            this.in = in;
            this.listener = listener == null ? _unassigned : listener;
            this.remainChar = (char)65535;
        }
    }

    public static interface Listener {
        public void foundNode(JsonNode var1, String var2, int var3) throws JsonParseAbort;
    }

    public static interface NodeBuilder {
        public JsonObject.Appendable createObject();

        public JsonArray.Appendable createArray();

        public JsonObject emptyObject();

        public JsonArray emptyArray();
    }
}

