/*
 * Decompiled with CFR 0.152.
 */
package cn.weforward.common.json;

import cn.weforward.common.json.JsonInput;
import cn.weforward.common.util.StringBuilderPool;
import cn.weforward.common.util.StringUtil;
import java.io.EOFException;
import java.io.IOException;

public class StringInput
implements JsonInput {
    String m_String;
    int m_Position;
    int m_End;

    public StringInput(String string) {
        this.m_String = string;
        this.m_Position = 0;
        this.m_End = string.length();
    }

    public StringInput(String str, int pos, int length) {
        this.m_End = length + pos;
        if (this.m_End > str.length()) {
            throw new IndexOutOfBoundsException("[" + length + "+" + pos + ">" + str.length() + "]" + StringUtil.limit(str, 100));
        }
        this.m_String = str;
        this.m_Position = pos;
    }

    public String getString() {
        return this.m_String;
    }

    @Override
    public int available() {
        if (this.m_End <= this.m_Position) {
            return -1;
        }
        return this.m_End - this.m_Position;
    }

    @Override
    public char readChar() throws IOException {
        if (this.m_Position >= this.m_End) {
            throw new EOFException();
        }
        return this.m_String.charAt(this.m_Position++);
    }

    @Override
    public int position() {
        return this.m_Position;
    }

    @Override
    public void close() throws IOException {
        this.m_String = "";
    }

    public String toString() {
        if (this.m_String == null || this.m_End == 0) {
            return "closed";
        }
        StringBuilder builder = StringBuilderPool._128.poll();
        try {
            builder.append('[').append(this.m_Position).append('/').append(this.m_End).append(']');
            int remain = this.m_End - this.m_Position;
            if (remain > 50) {
                remain = 50;
                builder.append(this.m_String, this.m_Position, this.m_Position + remain).append("...");
            } else {
                builder.append(this.m_String, this.m_Position, this.m_End);
            }
            String string = builder.toString();
            return string;
        }
        finally {
            StringBuilderPool._128.offer(builder);
        }
    }
}

