/*
 * Decompiled with CFR 0.152.
 */
package cn.weforward.common.json;

import cn.weforward.common.json.JsonOutput;
import cn.weforward.common.util.StringBuilderPool;
import java.io.IOException;

public class StringOutput
implements JsonOutput {
    StringBuilder m_Builder;

    private void sureOpen() throws IOException {
        if (this.m_Builder == null) {
            throw new IOException("closed");
        }
    }

    public StringOutput() {
        this.m_Builder = StringBuilderPool._8k.poll();
    }

    public StringOutput(int capacity) {
        this.m_Builder = new StringBuilder(capacity);
    }

    @Override
    public Appendable append(CharSequence csq) throws IOException {
        return this.append(csq, 0, csq.length());
    }

    @Override
    public Appendable append(CharSequence csq, int start, int end) throws IOException {
        this.sureOpen();
        return this.m_Builder.append(csq, start, end);
    }

    @Override
    public Appendable append(char c) throws IOException {
        this.sureOpen();
        return this.m_Builder.append(c);
    }

    @Override
    public void close() throws IOException {
        if (this.m_Builder != null && StringBuilderPool._8k.getInitialCapacity() == this.m_Builder.capacity()) {
            StringBuilderPool._8k.offer(this.m_Builder);
        }
        this.m_Builder = null;
    }

    public String toString() {
        if (this.m_Builder != null) {
            return this.m_Builder.toString();
        }
        return "";
    }
}

