/*
 * Decompiled with CFR 0.152.
 */
package cn.weforward.common.log;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.PatternLayout;
import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.core.AppenderBase;
import ch.qos.logback.core.Layout;
import cn.weforward.common.crypto.Base64;
import cn.weforward.common.json.JsonOutputStream;
import cn.weforward.common.json.JsonUtil;
import cn.weforward.common.util.RingBuffer;
import cn.weforward.common.util.StringBuilderPool;
import cn.weforward.common.util.StringUtil;
import java.io.IOException;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.UnknownServiceException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class DelayRemoteAppender
extends AppenderBase<ILoggingEvent>
implements Runnable {
    static final String DEFAULT_SUBJECT_PATTERN = "%logger{20}";
    static final String DEFAULT_SERVER = "unkonwn";
    final Object m_Lock = new Object();
    protected String m_Server = "unkonwn";
    protected String m_Subject = "%logger{20}";
    protected Layout<ILoggingEvent> m_SubjectLayout;
    protected Layout<ILoggingEvent> m_ContentLayout;
    protected RingBuffer<SenderVo> m_Items;
    protected long m_Interval = 1000L;
    protected long m_MaxSupport = 100L;
    protected List<URL> m_Urls;
    protected String m_Method = "write";
    protected Thread m_Thread;
    protected String m_ProjectName;
    protected String m_Serverid;
    protected String m_UserName;
    protected String m_Password;
    protected int m_ConnectTimeout = 3000;
    protected int m_ReadTimeout = 60000;
    protected String m_Authorization;

    public void start() {
        this.m_Items = new RingBuffer(1024);
        Thread thread = new Thread((Runnable)this, "DelayRemoteAppender");
        thread.setDaemon(true);
        this.m_Thread = thread;
        this.m_SubjectLayout = this.makeSubjectLayout(this.m_Subject);
        thread.start();
        super.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        super.stop();
        Object object = this.m_Lock;
        synchronized (object) {
            this.m_Thread = null;
            this.m_Lock.notify();
        }
    }

    public void setUrl(String url) {
        this.setUrls(Collections.singletonList(url));
    }

    public void setUrls(List<String> urls) {
        if (urls == null || urls.size() == 0) {
            this.m_Urls = Collections.emptyList();
            return;
        }
        ArrayList<URL> ls = new ArrayList<URL>(urls.size());
        for (String url : urls) {
            try {
                ls.add(new URL(url));
            }
            catch (MalformedURLException e) {
                this.addError("\u5ffd\u7565\u4e0d\u89c4\u8303\u7684url:" + url, e);
            }
        }
        this.m_Urls = ls;
    }

    public void setMethod(String method) {
        this.m_Method = method;
    }

    public void setProjectName(String projectName) {
        this.m_ProjectName = projectName;
    }

    public void setServerid(String sid) {
        this.m_Serverid = sid;
    }

    public void setServer(String server) {
        this.m_Server = server;
    }

    public void setSubject(String subject) {
        this.m_Subject = subject;
    }

    public void setInterval(int interval) {
        this.m_Interval = interval;
    }

    public void setMaxSupport(int max) {
        this.m_MaxSupport = max;
    }

    public void setUserName(String name) {
        this.m_UserName = name;
        this.m_Authorization = null;
    }

    public void setPassword(String password) {
        this.m_Password = password;
        this.m_Authorization = null;
    }

    public void setConnectTimeout(int t) {
        this.m_ConnectTimeout = t;
    }

    public void setReadTimeout(int t) {
        this.m_ReadTimeout = t;
    }

    protected Layout<ILoggingEvent> makeSubjectLayout(String subjectStr) {
        PatternLayout pl = new PatternLayout();
        pl.setContext(this.getContext());
        pl.setPattern(subjectStr);
        pl.setPostCompileProcessor(null);
        pl.start();
        return pl;
    }

    public Layout<ILoggingEvent> getLayout() {
        return this.m_ContentLayout;
    }

    public void setLayout(Layout<ILoggingEvent> layout) {
        this.m_ContentLayout = layout;
    }

    protected void append(ILoggingEvent eventObject) {
        if (this.m_Thread == null || this.m_Items == null) {
            return;
        }
        SenderVo vo = new SenderVo(this.getSubject(eventObject), this.getContent(eventObject), this.getLevel(eventObject));
        this.m_Items.offer(vo);
    }

    private String getSubject(ILoggingEvent event) {
        String subjectStr = "Undefined subject";
        if (this.m_SubjectLayout != null) {
            subjectStr = this.m_SubjectLayout.doLayout((Object)event);
        }
        return subjectStr;
    }

    private String getContent(ILoggingEvent event) {
        Layout<ILoggingEvent> layout = this.m_ContentLayout;
        StringBuilder content = StringBuilderPool._8k.poll();
        try {
            String footer;
            String presentationHeader;
            String header = layout.getFileHeader();
            if (header != null) {
                content.append(header);
            }
            if ((presentationHeader = layout.getPresentationHeader()) != null) {
                content.append(presentationHeader);
            }
            content.append(layout.doLayout((Object)event));
            String presentationFooter = layout.getPresentationFooter();
            if (presentationFooter != null) {
                content.append(presentationFooter);
            }
            if ((footer = layout.getFileFooter()) != null) {
                content.append(footer);
            }
            String string = content.toString();
            return string;
        }
        finally {
            StringBuilderPool._8k.offer(content);
        }
    }

    private String getLevel(ILoggingEvent event) {
        Level l = event.getLevel();
        return l == null ? "" : l.levelStr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        while (this.m_Thread != null) {
            Object object;
            try {
                do {
                    this.send();
                    object = this.m_Lock;
                    synchronized (object) {
                        try {
                            this.m_Lock.wait(this.m_Interval);
                        }
                        catch (InterruptedException e2) {
                            Thread.currentThread().interrupt();
                            return;
                        }
                        if (this.m_Thread == null) {
                            return;
                        }
                    }
                } while (this.m_Thread != null);
            }
            catch (Throwable e) {
                try {
                    this.addError("\u8fd0\u884c\u51fa\u9519", e);
                }
                catch (Throwable e2) {
                    // empty catch block
                }
            }
            object = this;
            synchronized (object) {
                try {
                    this.wait(10000L);
                }
                catch (InterruptedException e) {
                    return;
                }
            }
        }
    }

    private void send() {
        try {
            SenderVo vo;
            while ((vo = this.m_Items.remove()) != null) {
                this.send(vo.subject, vo.content, vo.level);
            }
        }
        catch (Exception e) {
            this.addError("Error occurred while sending Remote.", e);
        }
    }

    private String getServer() {
        if (StringUtil.eq(this.m_Server, DEFAULT_SERVER) && !StringUtil.isEmpty(this.m_ProjectName)) {
            return String.valueOf(this.m_ProjectName) + "_" + this.m_Serverid;
        }
        return this.m_Server;
    }

    private void send(String subject, String content, String level) {
        for (URL url : this.m_Urls) {
            try {
                this.send(url, this.getServer(), subject, content, level);
            }
            catch (Exception e) {
                this.addError("Error occurred while remote", e);
            }
        }
    }

    private void send(URL url, String server, String subject, String content, String level) throws IOException {
        HttpURLConnection http = null;
        http = (HttpURLConnection)url.openConnection();
        http.setConnectTimeout(this.m_ConnectTimeout);
        http.setReadTimeout(this.m_ReadTimeout);
        http.setChunkedStreamingMode(0);
        http.setDoInput(true);
        http.setDoOutput(true);
        http.setUseCaches(false);
        http.setRequestMethod("POST");
        if (this.m_Authorization == null) {
            this.m_Authorization = !StringUtil.isEmpty(this.m_UserName) && !StringUtil.isEmpty(this.m_Password) ? "Basic " + Base64.encode((String.valueOf(this.m_UserName) + ":" + this.m_Password).getBytes()) : "";
        }
        if (!StringUtil.isEmpty(this.m_Authorization)) {
            http.setRequestProperty("Authorization", this.m_Authorization);
        }
        OutputStream out = http.getOutputStream();
        JsonOutputStream builder = new JsonOutputStream(out);
        builder.append("{");
        builder.append("\"server\":\"");
        JsonUtil.escape(server, builder);
        builder.append("\",");
        builder.append("\"subject\":\"");
        JsonUtil.escape(subject, builder);
        builder.append("\",");
        builder.append("\"content\":\"");
        JsonUtil.escape(content, builder);
        builder.append("\",");
        builder.append("\"level\":\"");
        JsonUtil.escape(level, builder);
        builder.append("\"}");
        out.flush();
        builder.close();
        int status = http.getResponseCode();
        http.getInputStream().close();
        if (200 != status) {
            throw new UnknownServiceException(url + " \u65e5\u5fd7\u670d\u52a1\u5f02\u5e38\uff1a" + status + " " + http.getResponseMessage());
        }
    }

    static class SenderVo
    implements Comparable<SenderVo> {
        String subject;
        String content;
        String level;
        int num;

        public SenderVo(String subject, String content, String level) {
            this.subject = subject;
            this.content = content;
            this.level = level;
            this.num = 0;
        }

        public String getSubject() {
            return this.subject;
        }

        public String getLevel() {
            return this.level;
        }

        @Override
        public int compareTo(SenderVo o) {
            int i = o.subject.compareTo(this.subject);
            if (i == 0) {
                return o.level.compareTo(this.level);
            }
            return i;
        }
    }
}

