/*
 * Decompiled with CFR 0.152.
 */
package cn.weforward.common.restful;

import cn.weforward.common.execption.DuplicateNameException;
import cn.weforward.common.restful.RestfulAuthorizer;
import cn.weforward.common.restful.RestfulRequest;
import cn.weforward.common.restful.RestfulResponse;
import cn.weforward.common.restful.RestfulService;
import cn.weforward.common.util.UriMatcher;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class RestfulServices
implements RestfulService {
    protected Map<String, RestfulService> m_Services;
    protected UriMatcher m_UriMatcher;
    protected RestfulAuthorizer m_Authorizer;

    public void setServices(Map<String, RestfulService> services) {
        HashMap<String, RestfulService> map = new HashMap<String, RestfulService>(services.size());
        ArrayList<String> wildcards = null;
        for (Map.Entry<String, RestfulService> e : services.entrySet()) {
            String uri = e.getKey().toLowerCase();
            RestfulService old = map.put(uri, e.getValue());
            if (old != null) {
                if (old.equals(e.getValue())) continue;
                throw new DuplicateNameException("URI\u91cd\u590d\uff1a" + uri);
            }
            if (uri.indexOf(42) < 0) continue;
            if (wildcards == null) {
                wildcards = new ArrayList<String>();
            }
            wildcards.add(uri);
        }
        if (wildcards != null) {
            UriMatcher matcher = this.m_UriMatcher;
            if (matcher == null) {
                matcher = new UriMatcher();
            }
            matcher.setUris(wildcards);
            this.m_UriMatcher = matcher;
        }
        this.m_Services = map;
    }

    public void setAuthorizer(RestfulAuthorizer authorizer) {
        this.m_Authorizer = authorizer;
    }

    public RestfulService matchService(String uri) {
        String match;
        Map<String, RestfulService> services = this.m_Services;
        if (services == null || services.isEmpty()) {
            return null;
        }
        RestfulService service = services.get(uri);
        if (service != null) {
            return service;
        }
        UriMatcher matcher = this.m_UriMatcher;
        if (matcher != null && (match = matcher.match(uri)) != null) {
            service = services.get(match);
            return service;
        }
        return null;
    }

    @Override
    public void precheck(RestfulRequest request, RestfulResponse response) throws IOException {
        String accessId;
        if (this.m_Authorizer != null && (accessId = this.m_Authorizer.auth(request)) == null) {
            response.setStatus(403);
            response.openOutput().close();
            return;
        }
    }

    @Override
    public void service(RestfulRequest request, RestfulResponse response) throws IOException {
        RestfulService service;
        String uri = request.getUri();
        if (uri != null && uri.length() > 0) {
            uri = uri.toLowerCase();
        }
        if ((service = this.matchService(uri)) == null) {
            response.setStatus(404);
            response.openOutput().close();
            return;
        }
        service.service(request, response);
    }

    @Override
    public void timeout(RestfulRequest request, RestfulResponse response) throws IOException {
        RestfulService service;
        String uri = request.getUri();
        if (uri != null && uri.length() > 0) {
            uri = uri.toLowerCase();
        }
        if ((service = this.matchService(uri)) == null) {
            response.setStatus(404);
            response.openOutput().close();
            return;
        }
        service.timeout(request, response);
    }
}

