/*
 * Decompiled with CFR 0.152.
 */
package cn.weforward.common.sys;

import java.util.Timer;
import java.util.TimerTask;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClockTick
extends TimerTask {
    protected static final Timer _Timer = new Timer("ClockTick-Timer", true);
    protected static final int TICKER_INIT = 3600;
    protected static final Logger _Logger = LoggerFactory.getLogger(ClockTick.class);
    protected volatile long m_Ticker;
    protected final int m_Period;

    public static ClockTick getInstance(int period) {
        if (1 == period) {
            return Instances._C1;
        }
        if (10 == period) {
            return Instances._C10;
        }
        return new ClockTick(period, 3600 / period);
    }

    public static ClockTick getInstance(double period) {
        if (0.1 == period) {
            return Instances._C01;
        }
        if (0.01 == period) {
            return Instances._C001;
        }
        int v = (int)(period * 1000.0);
        if ((double)(v / 1000) == period) {
            return ClockTick.getInstance((int)period);
        }
        return new ClockTickMills(v, 3600);
    }

    public ClockTick(int period, int initTicker) {
        this.m_Ticker = initTicker;
        this.m_Period = period;
        _Timer.schedule((TimerTask)this, 0L, (long)(period * 1000));
    }

    protected ClockTick(int period) {
        this.m_Period = period;
    }

    public int getTicker() {
        return (int)this.m_Ticker;
    }

    public long getTickerLong() {
        return this.m_Ticker;
    }

    public long getMills() {
        return this.m_Ticker * (long)this.m_Period * 1000L;
    }

    public int getPeriod() {
        return this.m_Period;
    }

    public int getPeriodMills() {
        return this.m_Period * 1000;
    }

    public String toString() {
        return "{ticker:" + this.m_Ticker + ",period:" + this.m_Period + "}";
    }

    @Override
    public void run() {
        ++this.m_Ticker;
        if (this.m_Ticker >= Integer.MAX_VALUE) {
            _Logger.error("\u65f6\u95f4\u8ba1\u6570\u5668\u6ea2\u51fa " + this);
            this.m_Ticker = 1L;
        }
    }

    public static class ClockTickMills
    extends ClockTick {
        protected ClockTickMills(int period, int initTicker) {
            super(period);
            this.m_Ticker = initTicker;
            _Timer.schedule((TimerTask)this, 0L, (long)period);
        }

        @Override
        public void run() {
            ++this.m_Ticker;
        }

        @Override
        public int getPeriod() {
            return this.m_Period / 1000;
        }

        @Override
        public int getPeriodMills() {
            return this.m_Period;
        }

        @Override
        public int getTicker() {
            if (this.m_Ticker > Integer.MAX_VALUE) {
                throw new IllegalArgumentException("\u8ba1\u6570\u503c\u6ea2\u51fa[" + this.m_Ticker + "]");
            }
            return (int)this.m_Ticker;
        }

        @Override
        public long getMills() {
            return this.m_Ticker * (long)this.m_Period;
        }
    }

    private static class Instances {
        private static ClockTick _C001 = new ClockTickMills(10, 360000);
        private static ClockTick _C01 = new ClockTickMills(100, 36000);
        private static ClockTick _C1 = new ClockTick(1, 3600);
        private static ClockTick _C10 = new ClockTick(10, 360);

        private Instances() {
        }
    }
}

