/*
 * Decompiled with CFR 0.152.
 */
package cn.weforward.common.sys;

import cn.weforward.common.DestroyableExt;
import cn.weforward.common.GcCleanable;
import cn.weforward.common.NameItem;
import cn.weforward.common.crypto.Hex;
import cn.weforward.common.execption.AbortException;
import cn.weforward.common.sys.Memory;
import cn.weforward.common.sys.Shutdown;
import cn.weforward.common.sys.Timepoint;
import cn.weforward.common.sys.VmStat;
import cn.weforward.common.util.NumberUtil;
import cn.weforward.common.util.SinglyLinked;
import cn.weforward.common.util.SinglyLinkedLifo;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.SoftReference;
import java.lang.ref.WeakReference;
import java.util.Iterator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GcCleaner
implements DestroyableExt {
    static final int POLICY_SUSPEND = Memory.MEMORY_SUSPEND.id;
    static final Logger _Logger = LoggerFactory.getLogger(GcCleaner.class);
    public static final GcCleaner _Cleaner = new GcCleaner();
    protected static int _critical_suspend = NumberUtil.toInt(System.getProperty("cn.weforward.common.sys.GcCleaner.critical_suspend"), 1);
    ReferenceQueue<Object> m_ReferenceQueue = new ReferenceQueue();
    private Thread m_Thread;
    private final SinglyLinkedLifo<WeakReference<GcCleanable>> m_Cleanables = new SinglyLinkedLifo();
    volatile long m_LastSystemGc;
    int m_Interval = NumberUtil.toInt(System.getProperty("cn.weforward.common.util.GcCleaner.interval", null), 300000);

    public static boolean register(GcCleanable cleanable) {
        return _Cleaner.add(cleanable);
    }

    public static boolean unregister(GcCleanable cleanable) {
        return _Cleaner.remove(cleanable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void waitFor(long timeout) {
        block9: {
            Thread thread = GcCleaner._Cleaner.m_Thread;
            try {
                if (thread == null) {
                    GcCleaner gcCleaner = _Cleaner;
                    synchronized (gcCleaner) {
                        _Cleaner.wait(timeout);
                        break block9;
                    }
                }
                Thread thread2 = thread;
                synchronized (thread2) {
                    thread.wait(timeout);
                }
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
    }

    public static boolean isCriticalSuspend(boolean gc) {
        NameItem state = GcCleaner.getMemory().getLevel();
        if (1 == _critical_suspend && POLICY_SUSPEND == state.id) {
            if (gc && GcCleaner.gc()) {
                _Cleaner.calcPolicy();
            }
            state = GcCleaner.getMemory().getLevel();
            return POLICY_SUSPEND == state.id;
        }
        return false;
    }

    public static void dumpInfo() {
        _Cleaner.dump();
    }

    public static boolean gc() {
        return GcCleaner.gc(false);
    }

    public static boolean gc(boolean force) {
        long now = System.currentTimeMillis();
        long interval = now - GcCleaner._Cleaner.m_LastSystemGc;
        if (!force && interval < (long)GcCleaner._Cleaner.m_Interval) {
            return false;
        }
        GcCleaner._Cleaner.m_LastSystemGc = now;
        System.gc();
        _Logger.warn("{gc:\"System.gc()\",memory:" + GcCleaner.getMemory() + ",interval:" + interval + "}");
        return true;
    }

    public static Memory getMemory() {
        _Cleaner.calcPolicy();
        return VmStat.getMemory();
    }

    public static long calcMemForCache(int rate, long max) {
        GcCleaner.getMemory().refresh();
        long total = GcCleaner.getMemory().max;
        long need = total * (long)rate / 100L;
        if (need > max) {
            return max;
        }
        return need;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean add(GcCleanable c) {
        if (c == null) {
            return false;
        }
        SinglyLinkedLifo<WeakReference<GcCleanable>> singlyLinkedLifo = this.m_Cleanables;
        synchronized (singlyLinkedLifo) {
            block5: {
                if (!this.m_Cleanables.addIfAbsent(new CleanableReference(c))) break block5;
                _Logger.trace("add cleanable[{}] {}", (Object)this.m_Cleanables.size(), (Object)c);
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean remove(GcCleanable c) {
        if (c == null) {
            return false;
        }
        SinglyLinkedLifo<WeakReference<GcCleanable>> singlyLinkedLifo = this.m_Cleanables;
        synchronized (singlyLinkedLifo) {
            return this.m_Cleanables.remove(new CleanableReference(c));
        }
    }

    public void setInterval(int ms) {
        this.m_Interval = ms;
    }

    public void dump() {
        if (!_Logger.isInfoEnabled()) {
            return;
        }
        GcCleaner.getMemory().refresh();
        _Logger.info("****dump** [" + this.m_Cleanables.size() + "]" + GcCleaner.getMemory());
        int i = 0;
        SinglyLinked.SinglyLinkedNode p = this.m_Cleanables.getHead();
        while (p != null) {
            GcCleanable c = (GcCleanable)((WeakReference)p.value).get();
            if (c == null) {
                _Logger.info("<null> element at " + i);
            } else {
                _Logger.info("[" + c.getClass() + "]" + c.toString());
            }
            p = ((SinglyLinked.SinglyLinkedNode)p).getNext();
            ++i;
        }
        _Logger.info("************************");
    }

    public Iterator<WeakReference<GcCleanable>> getCleanables() {
        return this.m_Cleanables.iterator();
    }

    protected GcCleaner() {
        this.init();
        Shutdown.register(this);
    }

    protected void init() {
        this.m_Thread = new Thread(Shutdown.getRootThreadGroup(), "GcSignal.finalize"){

            @Override
            public void run() {
                Thread thread;
                SoftReference<Object> gcSignal = null;
                int gcSignalTick = GcSignal.getTicker();
                int period = Memory.getRefreshPeriod();
                while ((thread = GcCleaner.this.m_Thread) != null) {
                    try {
                        int policy;
                        Reference<Object> ret = null;
                        if (gcSignal == null) {
                            gcSignal = new SoftReference<Object>(new GcSignal(), GcCleaner.this.m_ReferenceQueue);
                            gcSignalTick = GcSignal.getTicker();
                            if (_Logger.isInfoEnabled()) {
                                _Logger.info("{GcSignal-reinit:" + Hex.toHex(gcSignal.hashCode()) + ",cleanables:" + GcCleaner.this.m_Cleanables.size() + ",memory:" + GcCleaner.getMemory() + "}");
                            }
                            ret = GcCleaner.this.m_ReferenceQueue.remove(30000L);
                            if (GcCleaner.this.m_Thread == null) break;
                        }
                        if (ret == null) {
                            ret = GcCleaner.this.m_ReferenceQueue.remove(period);
                        }
                        if (GcCleaner.this.m_Thread == null) break;
                        if (ret != null) {
                            if (ret == gcSignal) {
                                boolean fullGc;
                                gcSignal = null;
                                boolean bl = fullGc = GcSignal.getTicker() < gcSignalTick + 60;
                                if (_Logger.isInfoEnabled()) {
                                    _Logger.info("GcSignal-signaled:" + Hex.toHex(ret.hashCode()) + ",tick:" + (GcSignal.getTicker() - gcSignalTick) + "}");
                                }
                                policy = GcCleaner.this.calcPolicy();
                                if (fullGc && policy != 1) {
                                    policy = 16;
                                    GcCleaner.this.log(policy);
                                    GcCleaner.this.cleanup(policy);
                                    GcCleaner.gc();
                                } else {
                                    GcCleaner.this.log(policy);
                                    GcCleaner.this.cleanup(policy);
                                }
                            } else {
                                _Logger.error("{GcSignal-unexpect:" + Hex.toHex(ret.hashCode()) + ",ret:" + gcSignal + "}");
                                GcCleaner.this.cleanup();
                            }
                        } else {
                            if (_Logger.isInfoEnabled()) {
                                _Logger.info("{GcSignal-idel:" + gcSignal + ",cleanables:" + GcCleaner.this.m_Cleanables.size() + "}");
                            }
                            GcCleaner.this.cleanup();
                        }
                        policy = GcCleaner.this.calcPolicy();
                    }
                    catch (InterruptedException e) {
                        _Logger.info("{GcSignal-interrupt:" + gcSignal + ",cleanables:" + GcCleaner.this.m_Cleanables.size() + ",memory:" + GcCleaner.getMemory() + "}");
                        break;
                    }
                    catch (Throwable e) {
                        if (e instanceof OutOfMemoryError) continue;
                        _Logger.error(e.getMessage(), e);
                    }
                }
                GcCleaner.this.m_Thread = null;
                if (_Logger.isInfoEnabled()) {
                    _Logger.info("{GcSignal-destroy:" + gcSignal + ",cleanables:" + GcCleaner.this.m_Cleanables.size() + ",memory:" + GcCleaner.getMemory() + "}");
                }
            }
        };
        this.m_Thread.setDaemon(true);
        this.m_Thread.start();
    }

    public static int getPolicy() {
        return _Cleaner.calcPolicy();
    }

    private int calcPolicy() {
        int policy = VmStat.getMemory().refresh();
        policy = POLICY_SUSPEND == policy || Memory.MEMORY_CRITICAL.id == policy ? 16 : (Memory.MEMORY_LOW.id == policy ? 14 : 1);
        return policy;
    }

    private void log(int policy) {
        if (policy < 14) {
            if (_Logger.isInfoEnabled()) {
                _Logger.info("{GcSignal-cleanup:" + this.m_Cleanables.size() + ",state:IDLE" + ",memory:" + GcCleaner.getMemory() + "}");
            }
        } else if (_Logger.isWarnEnabled()) {
            _Logger.warn("{GcSignal-cleanup:" + this.m_Cleanables.size() + ",state:" + (16 == policy ? "CRITICAL" : (14 == policy ? "LOW" : "IDLE")) + ",memory:" + GcCleaner.getMemory() + "}");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cleanup() {
        int policy = this.calcPolicy();
        this.log(policy);
        int nilCount = this.cleanup(policy);
        if (nilCount > 0) {
            int old = this.m_Cleanables.size();
            SinglyLinkedLifo<WeakReference<GcCleanable>> singlyLinkedLifo = this.m_Cleanables;
            synchronized (singlyLinkedLifo) {
                SinglyLinked.SinglyLinkedNode p = this.m_Cleanables.detach();
                while (p != null) {
                    GcCleanable c = (GcCleanable)((WeakReference)p.value).get();
                    if (c != null) {
                        this.m_Cleanables.addHead((WeakReference)p.value);
                    }
                    p = ((SinglyLinked.SinglyLinkedNode)p).getNext();
                }
            }
            _Logger.info("Clear <null> elements:" + old + "/" + this.m_Cleanables.size());
        }
    }

    public int cleanup(int policy) {
        int nilCount = 0;
        SinglyLinked.SinglyLinkedNode p = this.m_Cleanables.getHead();
        while (p != null) {
            block7: {
                GcCleanable c = (GcCleanable)((WeakReference)p.value).get();
                if (c == null) {
                    ++nilCount;
                } else {
                    try {
                        c.onGcCleanup(policy);
                    }
                    catch (AbortException e) {
                        _Logger.error(String.valueOf(c.toString()) + " onGcCleanup abort!", (Throwable)e);
                        break;
                    }
                    catch (Throwable e) {
                        if (Thread.currentThread().isInterrupted()) {
                            _Logger.error(String.valueOf(c.toString()) + " onGcCleanup interrupted!", e);
                            break;
                        }
                        if (e instanceof OutOfMemoryError) break block7;
                        _Logger.error(String.valueOf(c.toString()) + " onGcCleanup failed.", e);
                    }
                }
            }
            p = ((SinglyLinked.SinglyLinkedNode)p).getNext();
        }
        return nilCount;
    }

    @Override
    public boolean destroySignal() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void destroy() {
        Thread thread = this.m_Thread;
        if (thread != null) {
            Thread thread2 = thread;
            synchronized (thread2) {
                if (this == _Cleaner) {
                    GcCleaner._Cleaner.m_LastSystemGc = System.currentTimeMillis();
                }
                this.m_Thread = null;
                thread.interrupt();
            }
        }
    }

    public String toString() {
        GcCleaner.getMemory().refresh();
        return "{mem:" + GcCleaner.getMemory() + ",lastGc:" + (System.currentTimeMillis() - this.m_LastSystemGc) / 1000L + ",interval:" + this.m_Interval + ",cleanables:" + this.m_Cleanables.size() + ",thread:" + this.m_Thread + "}";
    }

    static class CleanableReference
    extends WeakReference<GcCleanable> {
        public CleanableReference(GcCleanable referent) {
            super(referent);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            GcCleanable v = (GcCleanable)this.get();
            if (v == null) {
                return false;
            }
            if (obj instanceof WeakReference) {
                return v.equals(((WeakReference)obj).get());
            }
            return v.equals(obj);
        }
    }

    protected static class GcSignal {
        protected GcSignal() {
        }

        public String toString() {
            return Integer.toHexString(this.hashCode());
        }

        public static int getTicker() {
            return Timepoint.Tick.getInstance(1).getTicker();
        }
    }
}

