/*
 * Decompiled with CFR 0.152.
 */
package cn.weforward.common.sys;

import cn.weforward.common.crypto.Hex;
import cn.weforward.common.sys.Timestamp;
import cn.weforward.common.util.StringBuilderPool;
import cn.weforward.common.util.StringUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class IdGenerator {
    protected static final Logger _Logger = LoggerFactory.getLogger(IdGenerator.class);
    protected String m_ServerId;

    protected IdGenerator(String serverId) {
        this.m_ServerId = StringUtil.toString(serverId);
    }

    public String getServerId() {
        return this.m_ServerId;
    }

    public abstract String genId(String var1);

    public static String getServerId(String ordinal) {
        if (ordinal == null || ordinal.length() < 5) {
            return null;
        }
        int idx = ordinal.lastIndexOf(45);
        if (-1 != idx) {
            return ordinal.substring(idx + 1);
        }
        return null;
    }

    public static StringBuilder toHex(long val, StringBuilder builder) {
        int i32 = (int)(val >> 32 & 0xFFFFFFFFFFFFFFFFL);
        Hex.toHexFixed24(i32, builder);
        i32 = (int)(val & 0xFFFFFFFFFFFFFFFFL);
        Hex.toHexFixed(i32, builder);
        return builder;
    }

    public static class Tick
    extends IdGenerator {
        static final Timestamp _Timestamp = Timestamp.getInstance(Timestamp.POLICY_DEFAULT);

        public Tick(String serverId) {
            super(serverId);
        }

        @Override
        public String genId(String prefix) {
            long id = _Timestamp.next(0);
            id >>= 8;
            StringBuilder builder = StringBuilderPool._128.poll();
            try {
                if (!StringUtil.isEmpty(prefix)) {
                    builder.append(prefix);
                }
                Tick.toHex(id, builder);
                if (!StringUtil.isEmpty(this.m_ServerId)) {
                    builder.append('-');
                    builder.append(this.m_ServerId);
                }
                String string = builder.toString();
                return string;
            }
            finally {
                StringBuilderPool._128.offer(builder);
            }
        }

        public String toString() {
            StringBuilder builder = StringBuilderPool._128.poll();
            try {
                builder.append("{server:");
                builder.append(this.getServerId());
                builder.append(",ts:").append(_Timestamp);
                builder.append("}");
                String string = builder.toString();
                return string;
            }
            finally {
                StringBuilderPool._128.offer(builder);
            }
        }
    }
}

