/*
 * Decompiled with CFR 0.152.
 */
package cn.weforward.common.sys;

import cn.weforward.common.NameItem;
import cn.weforward.common.util.Bytes;
import cn.weforward.common.util.NumberUtil;
import cn.weforward.common.util.StringBuilderPool;
import java.io.InterruptedIOException;
import java.lang.management.GarbageCollectorMXBean;
import java.lang.management.ManagementFactory;
import java.util.List;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public class Memory {
    public static final NameItem MEMORY_IDEL = NameItem.valueOf("\u7a7a\u95f2", 1);
    public static final NameItem MEMORY_NORMAL = NameItem.valueOf("\u6b63\u5e38", 10);
    public static final NameItem MEMORY_LOW = NameItem.valueOf("\u4f4e", 14);
    public static final NameItem MEMORY_CRITICAL = NameItem.valueOf("\u7d27\u5f20", 16);
    public static final NameItem MEMORY_SUSPEND = NameItem.valueOf("\u5c06\u6302\u6389", 30);
    public long max;
    public long usable;
    public long alloc;
    public int gcCount;
    public int gcTime;
    protected NameItem m_Level = MEMORY_NORMAL;
    protected final Lock m_Lock = new ReentrantLock();
    protected final Condition m_LevelEvent = this.m_Lock.newCondition();
    protected long m_Critical;
    protected GarbageCollectorMXBean m_gc;

    public static int getRefreshPeriod() {
        int period = NumberUtil.toInt(System.getProperty("cn.weforward.common.sys.period"), 480000);
        return period;
    }

    public Memory() {
        List<GarbageCollectorMXBean> gcs = ManagementFactory.getGarbageCollectorMXBeans();
        for (GarbageCollectorMXBean gc : gcs) {
            String name = gc.getName();
            if (!name.equals("PS MarkSweep") && !name.equals("ConcurrentMarkSweep") && !name.contains(" Old ")) continue;
            this.m_gc = gc;
            break;
        }
    }

    public int refresh() {
        Lock lock = null;
        if (this.m_Lock.tryLock()) {
            lock = this.m_Lock;
        }
        try {
            Runtime runtime = Runtime.getRuntime();
            this.max = runtime.maxMemory();
            this.alloc = runtime.totalMemory();
            this.usable = runtime.freeMemory();
            if (Long.MAX_VALUE == this.max) {
                this.max = this.alloc;
            }
            if (this.max > this.alloc) {
                this.usable += this.max - this.alloc;
            }
            this.m_Level = this.calcSate();
            if (lock != null) {
                this.m_LevelEvent.signalAll();
            }
        }
        finally {
            if (lock != null) {
                this.m_Lock.unlock();
            }
        }
        if (this.m_gc != null) {
            this.gcCount = (int)this.m_gc.getCollectionCount();
            this.gcTime = (int)this.m_gc.getCollectionTime() / 1000;
        }
        return this.m_Level.id;
    }

    public long getMax() {
        return this.max;
    }

    public long getUsable() {
        return this.usable;
    }

    public long getAlloc() {
        return this.alloc;
    }

    public int getGcCount() {
        return this.gcCount;
    }

    public int getGcTime() {
        return this.gcTime;
    }

    public NameItem getLevel() {
        return this.m_Level;
    }

    public boolean checkLevel(NameItem level) {
        return level.id >= this.m_Level.id;
    }

    /*
     * Exception decompiling
     */
    public int waitFor(NameItem level, int timeoutMs) throws InterruptedIOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [6[DOLOOP]], but top level block is 2[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void setCritical(long bytes) {
        this.m_Critical = bytes;
    }

    protected NameItem calcSate() {
        if (this.m_Critical > 0L && this.usable < this.m_Critical) {
            return MEMORY_CRITICAL;
        }
        NameItem state = MEMORY_NORMAL;
        int rate = (int)(this.usable * 100L / this.max);
        if (rate <= 5 && this.m_Critical <= 0L) {
            state = MEMORY_CRITICAL;
        } else if (rate <= 10 && this.usable < 0x3200000L && this.m_Critical <= 0L) {
            state = MEMORY_CRITICAL;
        } else if (rate < 15 && this.usable <= Integer.MAX_VALUE) {
            state = MEMORY_LOW;
        } else if (rate >= 50) {
            state = MEMORY_IDEL;
        }
        if (this.usable < 0x2000000L || rate < 5 && this.m_Critical > 0L && this.usable < this.m_Critical) {
            state = MEMORY_SUSPEND;
        }
        return state;
    }

    public String toString() {
        StringBuilder builder = StringBuilderPool._128.poll();
        try {
            String string = this.toString(builder).toString();
            return string;
        }
        finally {
            StringBuilderPool._128.offer(builder);
        }
    }

    public StringBuilder toString(StringBuilder sb) {
        sb.append("{used:");
        Bytes.formatHumanReadable(sb, this.max - this.usable);
        sb.append(",usable:");
        Bytes.formatHumanReadable(sb, this.usable);
        sb.append(",max:");
        Bytes.formatHumanReadable(sb, this.max);
        if (this.max != this.alloc) {
            sb.append(",alloc:");
            Bytes.formatHumanReadable(sb, this.alloc);
        }
        if (this.m_Level != null) {
            sb.append(",level:").append(this.m_Level.name);
        }
        sb.append(",gc:").append(this.gcCount);
        sb.append(",gc-t:").append(this.gcTime);
        sb.append("}");
        return sb;
    }
}

