/*
 * Decompiled with CFR 0.152.
 */
package cn.weforward.common.sys;

import cn.weforward.common.Destroyable;
import cn.weforward.common.DestroyableExt;
import cn.weforward.common.crypto.Hex;
import cn.weforward.common.sys.VmStat;
import java.io.File;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Shutdown {
    static final Logger _Logger = LoggerFactory.getLogger(Shutdown.class);
    static final Shutdown _ShutdownHook = new Shutdown(true);
    private final List<WeakReference<Destroyable>> m_Destroyables = new ArrayList<WeakReference<Destroyable>>();
    private Runnable m_Finalizer;
    public static final Runnable PID_FILE_FINALIZER;

    static {
        _Logger.error("{shutdown-hook-init:" + Hex.toHex(_ShutdownHook.hashCode()) + ",thread:{" + Thread.currentThread() + "}}");
        PID_FILE_FINALIZER = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                String tmpDir = String.valueOf(System.getProperty("java.io.tmpdir", "/tmp")) + File.separatorChar + "wf-down" + File.separatorChar;
                try {
                    File tmp = new File(tmpDir);
                    tmp.mkdirs();
                    tmp = new File(String.valueOf(tmpDir) + VmStat.getPid());
                    if (tmp.createNewFile()) {
                        tmp.deleteOnExit();
                        1 var3_4 = this;
                        synchronized (var3_4) {
                            while (tmp.exists()) {
                                this.wait(5000L);
                            }
                        }
                    }
                    _Logger.info("halt");
                }
                catch (Exception e) {
                    _Logger.warn("PID_FILE_FINALIZER", (Throwable)e);
                }
            }
        };
    }

    public static boolean register(Destroyable destroyable) {
        return _ShutdownHook.add(destroyable);
    }

    public static boolean unregister(Destroyable destroyable) {
        return _ShutdownHook.add(destroyable);
    }

    public static void shutdown() {
        _ShutdownHook.cleanup();
    }

    public static void finalizer(Runnable finalizer) {
        _ShutdownHook.setFinalizer(finalizer);
    }

    public static ThreadGroup getRootThreadGroup() {
        ThreadGroup rg = Thread.currentThread().getThreadGroup();
        while (rg.getParent() != null) {
            rg = rg.getParent();
        }
        return rg;
    }

    public Shutdown() {
    }

    private Shutdown(boolean onJVM) {
        this();
        Thread hook = new Thread(Shutdown.getRootThreadGroup(), "shutdown-hook"){

            @Override
            public void run() {
                _Logger.error("{shutdown-begin:" + Hex.toHex(Shutdown.this.hashCode()) + "}");
                Shutdown.this.cleanup();
                Shutdown.this.m_Destroyables.clear();
                _Logger.info("{shutdown-end:" + Hex.toHex(Shutdown.this.hashCode()) + "}");
                Runnable finalizer = Shutdown.this.m_Finalizer;
                if (finalizer != null) {
                    _Logger.info("{shutdown-finality:" + Hex.toHex(Shutdown.this.hashCode()) + ",finalizer:" + finalizer + "}");
                    finalizer.run();
                }
            }
        };
        hook.setDaemon(false);
        Runtime.getRuntime().addShutdownHook(hook);
    }

    public void setFinalizer(Runnable finalizer) {
        this.m_Finalizer = finalizer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean add(Destroyable destroyable) {
        if (destroyable == null) {
            throw new IllegalArgumentException("destroyable is null!");
        }
        Shutdown shutdown = this;
        synchronized (shutdown) {
            int i = this.m_Destroyables.size() - 1;
            while (true) {
                if (i < 0) {
                    this.m_Destroyables.add(new WeakReference<Destroyable>(destroyable));
                    if (_Logger.isTraceEnabled()) {
                        _Logger.trace("{add:" + Hex.toHex(this.hashCode()) + ",size:" + this.m_Destroyables.size() + ",destroyable:" + destroyable.hashCode() + "}");
                    }
                    return true;
                }
                Destroyable da = (Destroyable)this.m_Destroyables.get(i).get();
                if (da == destroyable) {
                    return false;
                }
                --i;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean remove(Destroyable destroyable) {
        if (destroyable == null) {
            return false;
        }
        Shutdown shutdown = this;
        synchronized (shutdown) {
            int i = this.m_Destroyables.size() - 1;
            while (true) {
                if (i < 0) {
                    return false;
                }
                Destroyable da = (Destroyable)this.m_Destroyables.get(i).get();
                if (da == destroyable) {
                    this.m_Destroyables.remove(i);
                    if (_Logger.isTraceEnabled()) {
                        _Logger.trace("{remove:" + Hex.toHex(this.hashCode()) + ",size:" + this.m_Destroyables.size() + ",destroyable:" + destroyable.hashCode() + "}");
                    }
                    return true;
                }
                --i;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cleanup() {
        List<WeakReference<Destroyable>> list = this.m_Destroyables;
        synchronized (list) {
            try {
                _Logger.info("{signal:" + Hex.toHex(this.hashCode()) + ",size:" + this.m_Destroyables.size() + "}");
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            ArrayList<DestroyableExt> signals = new ArrayList<DestroyableExt>(this.m_Destroyables.size());
            ArrayList<Destroyable> destroy = new ArrayList<Destroyable>(this.m_Destroyables.size());
            int i2 = this.m_Destroyables.size() - 1;
            while (i2 >= 0) {
                block42: {
                    WeakReference<Destroyable> wr = this.m_Destroyables.get(i2);
                    Destroyable o = (Destroyable)wr.get();
                    if (o == null) {
                        if (_Logger.isTraceEnabled()) {
                            _Logger.trace("{null-element:" + i2 + "}");
                        }
                    } else {
                        try {
                            if (o instanceof DestroyableExt) {
                                DestroyableExt de = (DestroyableExt)o;
                                de.destroySignal();
                                signals.add(de);
                            } else {
                                destroy.add(o);
                            }
                        }
                        catch (Throwable e) {
                            if (e instanceof OutOfMemoryError) break block42;
                            _Logger.error("{signal:" + Hex.toHex(this.hashCode()) + ",fail:" + o + "}", e);
                        }
                    }
                }
                --i2;
            }
            if (destroy.size() > 0) {
                try {
                    _Logger.info("{destroy:" + Hex.toHex(this.hashCode()) + ",count:" + destroy.size() + ",size:" + this.m_Destroyables.size() + "}");
                }
                catch (Throwable i2) {
                    // empty catch block
                }
            }
            int i3 = 0;
            while (i3 < destroy.size()) {
                block43: {
                    Destroyable o = (Destroyable)destroy.get(i3);
                    if (o != null) {
                        try {
                            if (_Logger.isTraceEnabled()) {
                                _Logger.trace("{destroy:" + o + "}");
                            }
                            o.destroy();
                        }
                        catch (Throwable e) {
                            if (e instanceof OutOfMemoryError) break block43;
                            _Logger.error("{destroy:" + Hex.toHex(this.hashCode()) + ",fail:" + o + "}", e);
                        }
                    }
                }
                ++i3;
            }
            destroy = null;
            if (signals.size() == 0) {
                return;
            }
            ArrayList<DestroyableExt> remain = new ArrayList<DestroyableExt>(signals.size());
            ArrayList<DestroyableExt> loop = signals;
            int sleeping = 2000;
            long stopTime = System.currentTimeMillis() + 240000L;
            int t = 0;
            while (System.currentTimeMillis() < stopTime && t < 10000) {
                try {
                    _Logger.info("{signal:" + Hex.toHex(this.hashCode()) + ",loop:" + t + ",size:" + loop.size() + ",remain:" + remain.size() + "}");
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                remain.clear();
                for (DestroyableExt de : loop) {
                    if (de == null) continue;
                    try {
                        if (_Logger.isTraceEnabled()) {
                            _Logger.trace("{destroy-signal:" + de + "}");
                        }
                        if (!de.destroySignal()) continue;
                        remain.add(de);
                    }
                    catch (Throwable e) {
                        if (e instanceof OutOfMemoryError) continue;
                        _Logger.error("{signal:" + Hex.toHex(this.hashCode()) + ",fail:" + de + ",size:" + loop.size() + "}", e);
                    }
                }
                if (remain.isEmpty()) break;
                try {
                    Thread.interrupted();
                    Thread.sleep(sleeping);
                    sleeping = sleeping >= 10000 ? 10000 : (sleeping *= 2);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    _Logger.warn("{interrupt:" + Hex.toHex(this.hashCode()) + "}");
                }
                ++t;
            }
            try {
                if (remain.isEmpty()) {
                    _Logger.info("{final:" + Hex.toHex(this.hashCode()) + "}");
                } else {
                    StringBuilder sb = new StringBuilder(256);
                    sb.append("{force:").append(Hex.toHex(this.hashCode())).append(",size:").append(signals.size());
                    sb.append(",remain-").append(remain.size()).append(":[\n");
                    int i4 = 0;
                    while (i4 < remain.size()) {
                        if (i4 > 0) {
                            sb.append(",\n");
                        }
                        sb.append(remain.get(i4));
                        ++i4;
                    }
                    sb.append("]}");
                    _Logger.error(sb.toString());
                }
            }
            catch (Throwable sb) {
                // empty catch block
            }
            remain = null;
            signals = null;
            loop = null;
            int i5 = this.m_Destroyables.size() - 1;
            while (i5 >= 0) {
                block44: {
                    WeakReference<Destroyable> wr = this.m_Destroyables.get(i5);
                    Destroyable o = (Destroyable)wr.get();
                    if (o != null) {
                        try {
                            if (_Logger.isTraceEnabled()) {
                                _Logger.trace("destroy... " + o);
                            }
                            o.destroy();
                        }
                        catch (Throwable e) {
                            if (e instanceof OutOfMemoryError) break block44;
                            _Logger.error("{destroy-final:" + Hex.toHex(this.hashCode()) + ",fail:{" + o + "}}", e);
                        }
                    }
                }
                --i5;
            }
        }
    }
}

