/*
 * Decompiled with CFR 0.152.
 */
package cn.weforward.common.sys;

import cn.weforward.common.execption.Unexpected;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLDecoder;
import java.security.CodeSource;
import java.util.HashMap;
import java.util.Map;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;

public class StackTracer {
    static final Map<String, String> _JarVersions = new HashMap<String, String>();

    public static final Appendable printStackTrace(Thread thread, Appendable builder) {
        try {
            if (thread == null || thread == Thread.currentThread()) {
                StackTracer.printStackTrace(new Throwable().getStackTrace(), 1, 0, builder);
            } else {
                StackTracer.printStackTrace(thread.getStackTrace(), 0, 0, builder);
            }
        }
        catch (IOException ee) {
            throw new Unexpected(ee);
        }
        return builder;
    }

    public static final Appendable printStackTrace(Throwable e, Appendable builder) {
        if (e == null) {
            return builder;
        }
        Throwable cause = e.getCause();
        try {
            StackTraceElement[] stacks;
            if (cause != null && e != cause) {
                stacks = e.getStackTrace();
                if (builder == null) {
                    builder = new StringBuilder(stacks.length * 64);
                }
                builder.append(e.toString()).append('\n');
                String jarLast = null;
                int j = 0;
                while (j < stacks.length) {
                    StackTraceElement ste = stacks[j];
                    String jar = StackTracer.getJarVersion(ste.getClassName());
                    builder.append("\tat ").append(ste.toString());
                    if (jar != null && !jar.equals(jarLast)) {
                        builder.append('[').append(jar).append(']');
                        jarLast = jar;
                    }
                    builder.append('\n');
                    if (j >= 4) {
                        builder.append("\t...\nCaused by:");
                        break;
                    }
                    ++j;
                }
                e = cause;
            }
            stacks = e.getStackTrace();
            if (builder == null) {
                builder = new StringBuilder(stacks.length * 64);
            }
            if (Throwable.class != e.getClass()) {
                builder.append(e.toString());
            }
            builder.append('\n');
            StackTracer.printStackTrace(stacks, 0, 0, builder);
        }
        catch (IOException ee) {
            throw new Unexpected(ee);
        }
        return builder;
    }

    private static final Appendable printStackTrace(StackTraceElement[] stacks, int offset, int limit, Appendable appender) throws IOException {
        String jarLast = null;
        if (limit <= 0 || limit > stacks.length) {
            limit = stacks.length;
        }
        if (appender == null) {
            appender = new StringBuilder(limit * 64);
        }
        int j = offset >= limit ? (limit > 3 ? limit - 3 : 0) : offset;
        while (j < limit) {
            StackTraceElement ste = stacks[j];
            String className = ste.getClassName();
            if ("java.lang.reflect.Method".equals(className) || "sun.reflect.NativeConstructorAccessorImpl".equals(className)) {
                appender.append("\t...\n");
                break;
            }
            appender.append("\tat ").append(ste.toString());
            if ("_jspService".equals(ste.getMethodName())) {
                appender.append("\t...\n");
                break;
            }
            String jar = StackTracer.getJarVersion(ste.getClassName());
            if (jar != null && !jar.equals(jarLast)) {
                appender.append('[').append(jar).append(']');
                jarLast = jar;
            }
            appender.append('\n');
            ++j;
        }
        if (limit > offset && j > limit) {
            appender.append("\t...\n");
        }
        return appender;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final String getJarVersion(String className) {
        if (className.startsWith("java.") || className.startsWith("sun.")) {
            return "";
        }
        Map<String, String> map = _JarVersions;
        synchronized (map) {
            String ver = _JarVersions.get(className);
            if (ver != null) {
                return ver;
            }
            try {
                Class<?> clazz = Class.forName(className);
                ver = StackTracer.getJarVersion0(clazz);
            }
            catch (Throwable e) {
                ver = "";
            }
            _JarVersions.put(className, ver);
            return ver;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final String getJarVersion(Class<?> clazz) throws IOException {
        String className = clazz.getName();
        Map<String, String> map = _JarVersions;
        synchronized (map) {
            String ver = _JarVersions.get(className);
            if (ver != null) {
                return ver;
            }
            ver = StackTracer.getJarVersion0(clazz);
            _JarVersions.put(className, ver);
            return ver;
        }
    }

    private static final String getJarVersion0(Class<?> clazz) throws UnsupportedEncodingException {
        String name;
        String ver;
        int idx;
        String jar;
        block13: {
            if (clazz == null) {
                return "";
            }
            jar = null;
            try {
                URL url;
                CodeSource cs = clazz.getProtectionDomain().getCodeSource();
                if (cs != null && (url = cs.getLocation()) != null) {
                    jar = StackTracer.decodeUrl(url.getFile());
                }
            }
            catch (SecurityException cs) {
                // empty catch block
            }
            if (jar == null) {
                return "";
            }
            if (jar.startsWith("file:/")) {
                jar = jar.substring(5);
            }
            if (-1 != (idx = jar.indexOf(33))) {
                jar = jar.substring(0, idx);
            }
            if ((ver = _JarVersions.get(jar)) != null) {
                return ver;
            }
            try {
                idx = jar.lastIndexOf(47);
                if (-1 == idx) {
                    idx = jar.lastIndexOf(92);
                }
                if (-1 != (idx = (name = -1 != idx ? jar.substring(idx + 1) : jar).lastIndexOf(46))) break block13;
                return "";
            }
            catch (IOException iOException) {
                return "";
            }
        }
        name = name.substring(0, idx);
        JarFile jf = new JarFile(jar);
        Manifest mf = jf.getManifest();
        Attributes attributes = mf.getMainAttributes();
        ver = attributes.getValue("Implementation-Version");
        if (ver == null) {
            ver = "";
        }
        ver = String.valueOf(name) + ' ' + ver;
        jf.close();
        _JarVersions.put(jar, ver);
        return ver;
    }

    public static final String getJarManifestVersion(Class<?> clazz) {
        int idx;
        if (clazz == null) {
            return "";
        }
        String jar = null;
        try {
            URL url;
            CodeSource cs = clazz.getProtectionDomain().getCodeSource();
            if (cs != null && (url = cs.getLocation()) != null) {
                jar = url.getFile();
            }
        }
        catch (SecurityException cs) {
            // empty catch block
        }
        if (jar == null) {
            return "";
        }
        if (jar.startsWith("file:/")) {
            jar = jar.substring(5);
        }
        if (-1 != (idx = jar.indexOf(33))) {
            jar = jar.substring(0, idx);
        }
        try {
            JarFile jf = new JarFile(jar);
            Manifest mf = jf.getManifest();
            Attributes attributes = mf.getMainAttributes();
            String ver = attributes.getValue("Implementation-Version");
            if (ver == null) {
                ver = "";
            }
            jf.close();
            return ver;
        }
        catch (IOException iOException) {
            return "";
        }
    }

    public static String decodeUrl(String url) throws UnsupportedEncodingException {
        if (url == null || url.length() == 0) {
            return url;
        }
        return URLDecoder.decode(url, "UTF-8");
    }
}

