/*
 * Decompiled with CFR 0.152.
 */
package cn.weforward.common.sys;

import cn.weforward.common.execption.Unexpected;
import cn.weforward.common.sys.ClockTick;
import cn.weforward.common.util.StringBuilderPool;
import java.io.IOException;
import java.util.Calendar;
import java.util.TimeZone;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Timepoint {
    static final Logger _Logger = LoggerFactory.getLogger(Timepoint.class);
    public static final long BASE_TIME = 946721219000L;
    static final int DATUM_OFFSET = 10;
    final Tick m_ClockTick;
    static Calendar GMT_CALENDAR = Calendar.getInstance(TimeZone.getTimeZone("GMT"));
    private static final char[] _TenDigits = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9'};

    public static Timepoint getInstance(int unit) {
        if (1 == unit) {
            return Instances._C01;
        }
        if (2 == unit) {
            return Instances._C02;
        }
        if (10 == unit) {
            return Instances._C10;
        }
        return new Timepoint(unit);
    }

    public Timepoint(int unit) {
        this.m_ClockTick = new Tick(unit);
        this.m_ClockTick.datum();
    }

    public int getTimepoint() {
        return this.m_ClockTick.getTicker();
    }

    public int getUnit() {
        return this.m_ClockTick.getPeriod();
    }

    public int getSteps() {
        return this.m_ClockTick.m_Steps;
    }

    public String toString() {
        int t = this.getTimepoint();
        StringBuilder sb = StringBuilderPool._128.poll();
        try {
            sb.append(t).append("(");
            Timepoint.formatTimestamp(this.getTime(t), sb);
            sb.append(")/").append(this.getUnit()).append("\u79d2");
            String string = sb.toString();
            return string;
        }
        finally {
            StringBuilderPool._128.offer(sb);
        }
    }

    public int getTimepoint(long time) {
        int t = (int)((time - 946721219000L) / (long)(this.getUnit() * 1000));
        return t;
    }

    public long getTime(int timepoint) {
        long t = 1000L * (long)this.getUnit() * (long)timepoint + 946721219000L;
        return t;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final Appendable formatTimestamp(long timestamp, Appendable appender) {
        Calendar calendar = GMT_CALENDAR;
        synchronized (calendar) {
            Calendar c = GMT_CALENDAR;
            try {
                c.setTimeInMillis(timestamp);
                Timepoint.append4(appender, c.get(1));
                Timepoint.append2(appender, 1 + c.get(2));
                Timepoint.append2(appender, c.get(5));
                appender.append('T');
                Timepoint.append2(appender, c.get(11));
                Timepoint.append2(appender, c.get(12));
                Timepoint.append2(appender, c.get(13));
                Timepoint.append3(appender, c.get(14));
            }
            catch (IOException e) {
                throw new Unexpected(e);
            }
        }
        return appender;
    }

    private static final void append4(Appendable appender, int val) throws IOException {
        if (val >= 10) {
            if (val >= 100) {
                if (val >= 1000) {
                    appender.append(_TenDigits[val / 1000]);
                    val %= 1000;
                } else {
                    appender.append('0');
                }
                appender.append(_TenDigits[val / 100]);
                val %= 100;
            } else {
                appender.append('0');
                appender.append('0');
            }
            appender.append(_TenDigits[val / 10]);
            val %= 10;
        } else {
            appender.append('0');
            appender.append('0');
            appender.append('0');
        }
        appender.append(_TenDigits[val]);
    }

    private static final void append3(Appendable appender, int val) throws IOException {
        if (val >= 10) {
            if (val >= 100) {
                appender.append(_TenDigits[val / 100]);
                val %= 100;
            } else {
                appender.append('0');
            }
            appender.append(_TenDigits[val / 10]);
            val %= 10;
        } else {
            appender.append('0');
            appender.append('0');
        }
        appender.append(_TenDigits[val]);
    }

    private static final void append2(Appendable appender, int val) throws IOException {
        if (val >= 10) {
            appender.append(_TenDigits[val / 10]);
            val %= 10;
        } else {
            appender.append('0');
        }
        appender.append(_TenDigits[val]);
    }

    private static class Instances {
        private static Timepoint _C01 = new Timepoint(1);
        private static Timepoint _C02 = new Timepoint(2);
        private static Timepoint _C10 = new Timepoint(10);

        private Instances() {
        }
    }

    class Tick
    extends ClockTick {
        int m_Steps;

        public Tick(int period) {
            super(period, 0);
        }

        @Override
        public void run() {
            ++this.m_Steps;
            if (this.m_Steps >= 10) {
                this.m_Steps = 0;
                this.datum();
                return;
            }
            ++this.m_Ticker;
        }

        protected int datum() {
            int k;
            long now = System.currentTimeMillis();
            int t = (int)((now - 946721219000L) / (long)(Timepoint.this.getUnit() * 1000));
            if (t < (k = this.getTicker())) {
                StringBuilder sb = new StringBuilder("\u5f53\u524d\u7cfb\u7edf\u65f6\u95f4\u65e9\u4e8e\u4e0a\u4e2a\u65f6\u95f4\u70b9(" + Timepoint.this.getUnit() + "):");
                sb.append(k).append("/").append(t).append("(");
                Timepoint.formatTimestamp(Timepoint.this.getTime(k), sb);
                sb.append("/");
                Timepoint.formatTimestamp(now, sb);
                sb.append(")");
                _Logger.error(sb.toString());
                return k;
            }
            this.m_Ticker = t;
            if (_Logger.isDebugEnabled()) {
                StringBuilder sb = new StringBuilder("\u6821\u6b63\u65f6\u95f4\u70b9(" + Timepoint.this.getUnit() + "):");
                sb.append(k).append("/").append(t).append("(");
                Timepoint.formatTimestamp(Timepoint.this.getTime(k), sb);
                sb.append("/");
                Timepoint.formatTimestamp(now, sb);
                sb.append(")");
                _Logger.debug(sb.toString());
            }
            return t;
        }
    }
}

