/*
 * Decompiled with CFR 0.152.
 */
package cn.weforward.common.sys;

import cn.weforward.common.execption.OverflowException;
import cn.weforward.common.sys.ClockTick;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.ReentrantLock;

public abstract class Timestamp {
    public static int MASK_SERVER = 255;
    public static int MASK_ORDINAL = 65280;
    public static long MASK_TIMESTAMP = 0xFFFFFFFFFFF0000L;
    public static long MARK_REMOVED = Long.MIN_VALUE;
    public static long MASK_MARK = -1152921504606846976L;
    public static long MASK_TIME_AND_ORDINAL = 0xFFFFFFFFFFFFF00L;
    public static int POLICY_DEFAULT = 0;
    public static int POLICY_UNSAFE = 1;
    public static int POLICY_CAS = 2;
    public static int POLICY_LOCK = 3;
    public static int POLICY_SYNC = 4;
    static final ClockTick _Tick = ClockTick.getInstance(1);
    static final int TIME_TICKS = 5;
    static final int MAX_INTERVAL = 1275000;
    volatile long m_Datum;
    volatile int m_LastTick;

    public static Timestamp getInstance(int policy) {
        if (POLICY_CAS == policy) {
            return new CasTimestamp();
        }
        if (POLICY_LOCK == policy) {
            return new LockTimestamp();
        }
        if (POLICY_UNSAFE == policy) {
            return new UnsafeTimestamp();
        }
        if (POLICY_DEFAULT == policy || POLICY_SYNC == policy) {
            return new SyncTimestamp();
        }
        throw new IllegalArgumentException("\u53c2\u6570\u65e0\u6548\uff1a" + policy);
    }

    public static final long getTime(long v) {
        return (MASK_TIMESTAMP & v) >> 16;
    }

    public static final long getTimeBits(long v) {
        return MASK_TIME_AND_ORDINAL & v;
    }

    public static final int getOrdinal(long v) {
        return (int)(0xFF00L & v) >> 8;
    }

    public static final int getServerId(long v) {
        return (int)(0xFFL & v);
    }

    public static final boolean isMark(long v, long mark) {
        return mark == (v & mark);
    }

    public static final long getTimestamp(long t, int ordinal, int serverId) {
        t <<= 16;
        t |= (long)(0xFF00 & ordinal << 8);
        return t |= (long)(0xFF & serverId);
    }

    public static final long unmark(long timestamp) {
        return timestamp & (MASK_MARK ^ 0xFFFFFFFFFFFFFFFFL);
    }

    public abstract long next(int var1);

    protected long datum() {
        long t;
        this.m_Datum = t = System.currentTimeMillis() << 8;
        this.m_LastTick = _Tick.getTicker();
        return t;
    }

    static class CasTimestamp
    extends Timestamp {
        final AtomicLong m_LastStamp = new AtomicLong(this.datum());

        CasTimestamp() {
        }

        @Override
        public long next(int serverId) {
            int c = 0;
            while (c < 1000) {
                long t;
                long v = this.m_LastStamp.get();
                int d = _Tick.getTicker();
                if (d > this.m_LastTick + 5 && (t = this.datum()) > v && this.m_LastStamp.compareAndSet(v, t)) {
                    return t << 8 | (long)(0xFF & serverId);
                }
                t = v + 1L;
                long m = this.m_Datum + 1275000L;
                if (t > m) {
                    throw new OverflowException("\u5728\u77ed\u65f6\uff085\u79d2\uff09\u5185\u751f\u6210\u592a\u591a\u65f6\u95f4\u6233\uff1a" + (t - this.m_Datum));
                }
                if (this.m_LastStamp.compareAndSet(v, t)) {
                    return t << 8 | (long)(0xFF & serverId);
                }
                ++c;
            }
            throw new OverflowException("CAS\u5c1d\u8bd5\u8fc7\u591a\uff081000\u6b21\uff09");
        }

        public String toString() {
            return "{CAS:" + this.m_LastStamp.get() + "}";
        }
    }

    static class LockTimestamp
    extends UnsafeTimestamp {
        final ReentrantLock m_Lock = new ReentrantLock();

        LockTimestamp() {
        }

        @Override
        public long next(int serverId) {
            this.m_Lock.lock();
            try {
                long l = this.unsafeNext(serverId);
                return l;
            }
            finally {
                this.m_Lock.unlock();
            }
        }

        @Override
        public String toString() {
            return "[\u91cd\u5165\u9501]" + this.m_LastStamp;
        }
    }

    static class SyncTimestamp
    extends UnsafeTimestamp {
        SyncTimestamp() {
        }

        @Override
        public synchronized long next(int serverId) {
            return this.unsafeNext(serverId);
        }

        @Override
        public String toString() {
            return "{synchronized:" + this.m_LastStamp + "}";
        }
    }

    static class UnsafeTimestamp
    extends Timestamp {
        volatile long m_LastStamp = this.datum();

        protected UnsafeTimestamp() {
        }

        @Override
        public long next(int serverId) {
            return this.unsafeNext(serverId);
        }

        final long unsafeNext(int serverId) {
            long t;
            long v = this.m_LastStamp;
            int d = _Tick.getTicker();
            if (d > this.m_LastTick + 5 && (t = this.datum()) > v) {
                this.m_LastStamp = t;
                return t << 8 | (long)(0xFF & serverId);
            }
            t = v + 1L;
            long m = this.m_Datum + 1275000L;
            if (t > m) {
                throw new OverflowException("\u5728\u77ed\u65f6\uff085\u79d2\uff09\u5185\u751f\u6210\u592a\u591a\u65f6\u95f4\u6233\uff1a" + (t - this.m_Datum));
            }
            this.m_LastStamp = t;
            return t << 8 | (long)(0xFF & serverId);
        }

        public String toString() {
            return "{Unsafe:" + this.m_LastStamp + "}";
        }
    }
}

