/*
 * Decompiled with CFR 0.152.
 */
package cn.weforward.common.sys;

import cn.weforward.common.sys.Memory;
import cn.weforward.common.util.NumberUtil;
import com.sun.management.OperatingSystemMXBean;
import java.lang.management.ManagementFactory;
import java.lang.management.ThreadMXBean;

public class VmStat {
    protected Memory m_Memory = new Memory();
    protected int m_LoadAverage;
    protected int m_ProcessCpuLoad = -1;
    protected int m_ThreadCount;
    protected int m_Pid;
    public static int _cpus = Runtime.getRuntime().availableProcessors();
    public static final VmStat _VmStat = new VmStat();

    public static Memory getMemory() {
        return VmStat._VmStat.m_Memory;
    }

    public static int getLoadAverage() {
        return VmStat._VmStat.m_LoadAverage;
    }

    public static int getProcessCpuLoad() {
        return VmStat._VmStat.m_ProcessCpuLoad;
    }

    public static int getThreadCount() {
        return VmStat._VmStat.m_ThreadCount;
    }

    public static int getPid() {
        return VmStat._VmStat.m_Pid;
    }

    public static void refresh() {
        _VmStat.refresh0();
    }

    private VmStat() {
        String name = ManagementFactory.getRuntimeMXBean().getName();
        int idx = name.indexOf(64);
        if (idx > 0) {
            name = name.substring(0, idx);
            this.m_Pid = NumberUtil.toInt(name, 0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refresh0() {
        this.m_Memory.refresh();
        VmStat vmStat = this;
        synchronized (vmStat) {
            ThreadMXBean tmx;
            java.lang.management.OperatingSystemMXBean os = ManagementFactory.getOperatingSystemMXBean();
            if (os != null) {
                this.m_LoadAverage = (int)(os.getSystemLoadAverage() * 100.0);
                if (os instanceof OperatingSystemMXBean) {
                    this.m_ProcessCpuLoad = (int)(100.0 * ((OperatingSystemMXBean)os).getProcessCpuLoad());
                }
            }
            if ((tmx = ManagementFactory.getThreadMXBean()) != null) {
                this.m_ThreadCount = tmx.getThreadCount();
            }
        }
    }

    public String toString() {
        return "{pid:" + this.m_Pid + ",cpus:" + _cpus + ",cpu-load:" + this.m_ProcessCpuLoad + ",sys-load:" + this.m_LoadAverage + ",mem:" + this.m_Memory + "}";
    }
}

