/*
 * Decompiled with CFR 0.152.
 */
package cn.weforward.common.util;

import cn.weforward.common.ResultPage;
import java.util.Comparator;
import java.util.Iterator;
import java.util.NoSuchElementException;

public abstract class AbstractResultPage<E>
implements ResultPage<E> {
    protected int m_PageSize = 50;
    protected int m_PageCount = -1;
    protected int m_CurrentPage;
    protected int m_CurrentPos;
    protected int m_CurrentPageEnd;
    protected int m_CurrentPageBegin;
    protected int m_NextCount = -1;

    protected abstract E get(int var1);

    protected boolean onCountNext(int nextCount) {
        return false;
    }

    protected AbstractResultPage() {
    }

    protected AbstractResultPage(int nextCount) {
        this.m_NextCount = nextCount;
    }

    @Override
    public int getPageCount() {
        if (-1 == this.m_PageCount) {
            this.reinit();
        }
        return this.m_PageCount;
    }

    @Override
    public int getPageSize() {
        return this.m_PageSize;
    }

    @Override
    public void setPage(int page) {
        if (!this.gotoPage(page)) {
            throw new IndexOutOfBoundsException("over page " + page + " at 1~" + this.getPageCount());
        }
    }

    @Override
    public boolean gotoPage(int page) {
        if (page < 1 || page > this.getPageCount()) {
            return false;
        }
        this.m_CurrentPageBegin = this.m_CurrentPos = (page - 1) * this.getPageSize();
        if (page == this.m_CurrentPage) {
            return true;
        }
        this.m_CurrentPage = page;
        this.m_CurrentPageEnd = this.m_CurrentPos + this.getPageSize();
        if (this.m_CurrentPageEnd > this.getCount()) {
            this.m_CurrentPageEnd = this.getCount();
        }
        return true;
    }

    protected void checkPageSize(int size) {
    }

    @Override
    public void setPageSize(int size) {
        this.checkPageSize(size);
        if (this.m_PageSize != size && size > 0) {
            this.m_PageSize = -1 == size ? this.getCount() : size;
            this.reinit();
        }
    }

    @Override
    public boolean hasNext() {
        return this.m_CurrentPos < this.m_CurrentPageEnd;
    }

    @Override
    public E next() {
        if (this.hasNext()) {
            if (this.m_NextCount >= 0 && !this.onCountNext(++this.m_NextCount)) {
                this.m_NextCount = -2;
            }
            return this.get(this.m_CurrentPos++);
        }
        throw new NoSuchElementException("\u8bbf\u95ee\u8d8a\u754c\uff1a" + this.m_CurrentPos + "/" + this.getCount());
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("\u6b64\u529f\u80fd\u4e0d\u652f\u6301");
    }

    @Override
    public boolean hasPrev() {
        return this.m_CurrentPos > this.m_CurrentPageBegin;
    }

    @Override
    public E prev() {
        return this.hasPrev() ? (E)this.get(--this.m_CurrentPos) : null;
    }

    @Override
    public E move(int pos) {
        if (pos >= 0 && pos < this.m_CurrentPageEnd - this.m_CurrentPageBegin) {
            this.m_CurrentPos = this.m_CurrentPageBegin + pos;
            return this.get(this.m_CurrentPos);
        }
        return null;
    }

    @Override
    public int getPage() {
        return this.m_CurrentPage;
    }

    @Override
    public Iterator<E> iterator() {
        return this;
    }

    public void sort(Comparator<E> c, int limit) {
        throw new UnsupportedOperationException("\u6b64\u529f\u80fd\u4e0d\u652f\u6301\uff1a" + c);
    }

    protected void reinit() {
        this.m_PageCount = this.getCount() / this.m_PageSize;
        if (this.getCount() % this.m_PageSize > 0) {
            ++this.m_PageCount;
        }
        this.m_CurrentPage = 0;
        this.m_CurrentPos = 0;
        this.m_CurrentPageBegin = 0;
        this.m_CurrentPageEnd = 0;
    }

    public String toString() {
        return "{c:" + this.getCount() + ",ps:" + this.m_PageSize + ",pc:" + this.m_PageCount + ",p:" + this.m_CurrentPage + ",idx:" + this.m_CurrentPos + "}";
    }
}

