/*
 * Decompiled with CFR 0.152.
 */
package cn.weforward.common.util;

import cn.weforward.common.util.RingBuffer;
import cn.weforward.common.util.StringUtil;
import java.lang.reflect.Array;
import java.nio.file.InvalidPathException;
import java.util.regex.Pattern;

public class AntPathPattern {
    static final char SEPARATOR = '/';
    static final String[] EMPTY_STRING_ARRAY = new String[0];
    static final Pattern[] EMPTY_PATTERN_ARRAY = new Pattern[0];
    static final char[] WILDCARD_CHARS = new char[]{'*', '?'};
    static final int MAX_TOKENIZE_SLICE = 50;
    private char m_Separator;
    private boolean m_StartsWithSeparator;
    private boolean m_EndsWithSeparator;
    private String[] m_PattDirs;
    private Pattern[] m_DirPatterns;

    private AntPathPattern(String pattern, char pathSeparator) {
        if (pattern == null) {
            throw new IllegalArgumentException("'pattern' is required");
        }
        this.m_Separator = pathSeparator;
        this.compile(pattern);
    }

    public static AntPathPattern valueOf(String pattern) {
        return AntPathPattern.valueOf(pattern, '/');
    }

    public static AntPathPattern valueOf(String pattern, char pathSeparator) {
        return new AntPathPattern(pattern, pathSeparator);
    }

    public static boolean match(String pattern, String path) {
        AntPathPattern ant = AntPathPattern.valueOf(pattern);
        return ant.match(path);
    }

    public static boolean matchStart(String pattern, String path) {
        AntPathPattern ant = AntPathPattern.valueOf(pattern);
        return ant.matchStart(path);
    }

    private void compile(String pattern) {
        if (pattern.length() == 0) {
            this.m_StartsWithSeparator = false;
            this.m_EndsWithSeparator = false;
            this.m_PattDirs = EMPTY_STRING_ARRAY;
            this.m_DirPatterns = EMPTY_PATTERN_ARRAY;
        } else {
            this.m_StartsWithSeparator = AntPathPattern.startsWith(pattern, this.m_Separator);
            this.m_EndsWithSeparator = AntPathPattern.endsWith(pattern, this.m_Separator);
            Tokenizer tokenizer = AntPathPattern.tokenizePath(pattern, this.m_Separator);
            this.m_PattDirs = tokenizer.size() > 0 ? tokenizer.toArray(new String[tokenizer.size()]) : EMPTY_STRING_ARRAY;
            Singleton._tokenizerPool.offer(tokenizer);
            this.m_DirPatterns = new Pattern[this.m_PattDirs.length];
            int i = 0;
            while (i < this.m_PattDirs.length) {
                String dir = this.m_PattDirs[i];
                this.m_DirPatterns[i] = "**".equals(dir) || "*".equals(dir) || "?".equals(dir) ? null : AntPathPattern.toRegexPattern(dir);
                ++i;
            }
        }
    }

    static Pattern toRegexPattern(String antPattern) {
        StringBuilder sb = new StringBuilder();
        int bi = 0;
        int ei = 0;
        while (ei < antPattern.length()) {
            char c = antPattern.charAt(ei);
            if ('?' == c || '*' == c) {
                if (ei > bi) {
                    sb.append(Pattern.quote(antPattern.substring(bi, ei)));
                }
                if ('?' == c) {
                    sb.append('.');
                } else {
                    sb.append('.').append('*');
                }
                bi = ei + 1;
            }
            ++ei;
        }
        if (bi < antPattern.length()) {
            sb.append(Pattern.quote(antPattern.substring(bi)));
        }
        return Pattern.compile(sb.toString());
    }

    static boolean startsWith(String str, char ch) {
        if (str.length() == 0) {
            return false;
        }
        return ch == str.charAt(0);
    }

    static boolean endsWith(String str, char ch) {
        if (str.length() == 0) {
            return false;
        }
        return ch == str.charAt(str.length() - 1);
    }

    static Tokenizer tokenizePath(String path, char separator) {
        if (StringUtil.isEmpty(path)) {
            return Singleton._emptyTokenizer;
        }
        Tokenizer tokenizer = Singleton._tokenizerPool.poll();
        tokenizer.tokenize(path, separator);
        return tokenizer;
    }

    public boolean match(String path) {
        return this.match0(path, false);
    }

    public boolean matchStart(String path) {
        return this.match0(path, true);
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean match0(String path, boolean startMatch) {
        if (this.m_StartsWithSeparator != AntPathPattern.startsWith(path, this.m_Separator)) {
            return false;
        }
        if (!startMatch && !this.isRoughlyMatch(path)) {
            return false;
        }
        pattDirs = this.m_PattDirs;
        pattIdxStart = 0;
        pattIdxEnd = pattDirs.length - 1;
        pathIdxStart = 0;
        pathDirs = null;
        try {
            block41: {
                pathDirs = AntPathPattern.tokenizePath(path, this.m_Separator);
                pathIdxEnd = pathDirs.size() - 1;
                while (pattIdxStart <= pattIdxEnd && pathIdxStart <= pathIdxEnd) {
                    pattDir = pattDirs[pattIdxStart];
                    if ("**".equals(pattDir)) break;
                    if (!this.matchStrings(pattIdxStart, pathDirs.slice(pathIdxStart))) {
                        return false;
                    }
                    ++pattIdxStart;
                    ++pathIdxStart;
                }
                if (pathIdxStart <= pathIdxEnd) break block41;
                if (pattIdxStart > pattIdxEnd) {
                    var18_14 = this.m_EndsWithSeparator == AntPathPattern.endsWith(path, this.m_Separator);
                    return var18_14;
                }
                if (startMatch) {
                    return true;
                }
                if (pattIdxStart == pattIdxEnd && pattDirs[pattIdxStart].equals("*") && AntPathPattern.endsWith(path, this.m_Separator)) {
                    return true;
                }
                i = pattIdxStart;
                if (true) ** GOTO lbl41
            }
            if (pattIdxStart > pattIdxEnd) {
                return false;
            }
            if (startMatch && "**".equals(pattDirs[pattIdxStart])) {
                return true;
            }
            ** GOTO lbl48
            do {
                if (!pattDirs[i].equals("**")) {
                    return false;
                }
                ++i;
lbl41:
                // 2 sources

            } while (i <= pattIdxEnd);
            return true;
            while (!(pattDir = pattDirs[pattIdxEnd]).equals("**")) {
                if (!this.matchStrings(pattIdxEnd, pathDirs.slice(pathIdxEnd))) {
                    return false;
                }
                --pattIdxEnd;
                --pathIdxEnd;
lbl48:
                // 2 sources

                if (pattIdxStart <= pattIdxEnd && pathIdxStart <= pathIdxEnd) continue;
            }
            if (pathIdxStart <= pathIdxEnd) ** GOTO lbl88
            i = pattIdxStart;
            while (i <= pattIdxEnd) {
                if (!pattDirs[i].equals("**")) {
                    return false;
                }
                ++i;
            }
            return true;
lbl-1000:
            // 1 sources

            {
                patIdxTmp = -1;
                i = pattIdxStart + 1;
                while (i <= pattIdxEnd) {
                    if (pattDirs[i].equals("**")) {
                        patIdxTmp = i;
                        break;
                    }
                    ++i;
                }
                if (patIdxTmp == pattIdxStart + 1) {
                    ++pattIdxStart;
                    continue;
                }
                patLength = patIdxTmp - pattIdxStart - 1;
                strLength = pathIdxEnd - pathIdxStart + 1;
                foundIdx = -1;
                i = 0;
                block21: while (i <= strLength - patLength) {
                    j = 0;
                    while (j < patLength) {
                        subPatIdx = pattIdxStart + j + 1;
                        subStrIdx = pathIdxStart + i + j;
                        if (!this.matchStrings(subPatIdx, pathDirs.slice(subStrIdx))) {
                            ++i;
                            continue block21;
                        }
                        ++j;
                    }
                    foundIdx = pathIdxStart + i;
                    break;
                }
                if (foundIdx == -1) {
                    return false;
                }
                pattIdxStart = patIdxTmp;
                pathIdxStart = foundIdx + patLength;
lbl88:
                // 3 sources

                ** while (pattIdxStart != pattIdxEnd && pathIdxStart <= pathIdxEnd)
            }
lbl89:
            // 1 sources

        }
        finally {
            Singleton._tokenizerPool.offer(pathDirs);
        }
        i = pattIdxStart;
        while (i <= pattIdxEnd) {
            if (!pattDirs[i].equals("**")) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private boolean isRoughlyMatch(String path) {
        int pos = 0;
        String[] stringArray = this.m_PattDirs;
        int n = this.m_PattDirs.length;
        int n2 = 0;
        while (n2 < n) {
            String pattDir = stringArray[n2];
            int skipped = this.skipSeparator(path, pos);
            if ((skipped = this.skipDir(path, pos += skipped, pattDir)) < pattDir.length()) {
                return skipped > 0 || pattDir.length() > 0 && this.isWildcardChar(pattDir.charAt(0));
            }
            pos += skipped;
            ++n2;
        }
        return true;
    }

    private int skipDir(String path, int pos, String dir) {
        int skipped = 0;
        int i = 0;
        while (i < dir.length()) {
            char c = dir.charAt(i);
            if (this.isWildcardChar(c)) {
                return skipped;
            }
            int currPos = pos + skipped;
            if (currPos >= path.length()) {
                return 0;
            }
            if (c == path.charAt(currPos)) {
                ++skipped;
            }
            ++i;
        }
        return skipped;
    }

    private int skipSeparator(String path, int pos) {
        if (pos >= path.length()) {
            return 0;
        }
        int skipped = 0;
        while (this.m_Separator == path.charAt(pos + skipped)) {
            if (pos + ++skipped >= path.length()) break;
        }
        return skipped;
    }

    private boolean isWildcardChar(char c) {
        char[] cArray = WILDCARD_CHARS;
        int n = WILDCARD_CHARS.length;
        int n2 = 0;
        while (n2 < n) {
            char candidate = cArray[n2];
            if (c == candidate) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private boolean matchStrings(int subPatIdx, CharSequence charSequence) {
        if ("*".equals(this.m_PattDirs[subPatIdx])) {
            return true;
        }
        if ("?".equals(this.m_PattDirs[subPatIdx])) {
            return 1 == charSequence.length();
        }
        return this.m_DirPatterns[subPatIdx].matcher(charSequence).matches();
    }

    private static class Singleton {
        static Tokenizer _emptyTokenizer = new Tokenizer();
        static RingBuffer<Tokenizer> _tokenizerPool = new RingBuffer<Tokenizer>(128){

            @Override
            protected Tokenizer onEmpty() {
                return new Tokenizer();
            }

            @Override
            public boolean offer(Tokenizer item) {
                if (item == null || _emptyTokenizer == item) {
                    return false;
                }
                item.cleanup();
                return super.offer(item);
            }
        };

        private Singleton() {
        }
    }

    public static class Tokenizer {
        CharSequence string;
        int[] indexs;
        int size;

        public String[] toArray(String[] strings) {
            if (this.size() != strings.length) {
                strings = (String[])Array.newInstance(strings.getClass().getComponentType(), this.size());
            }
            int i = this.size() - 1;
            while (i >= 0) {
                strings[i] = this.slice(i).toString();
                --i;
            }
            return strings;
        }

        public void tokenize(CharSequence string, char separator) {
            this.string = string;
            this.size = 1;
            if (this.indexs == null) {
                this.indexs = new int[51];
            }
            int length = string.length();
            this.indexs[0] = string.charAt(0) == separator ? 0 : -1;
            int i = 1;
            while (i < length) {
                if (string.charAt(i) == separator) {
                    if (this.size >= this.indexs.length) {
                        throw new InvalidPathException(string.toString(), "\u8def\u5f84\u5206\u5272\u6570\u8d85\u8fc7" + this.size);
                    }
                    this.indexs[this.size++] = i;
                }
                ++i;
            }
            if (this.indexs[this.size - 1] + 1 < string.length()) {
                if (this.size >= this.indexs.length) {
                    throw new InvalidPathException(string.toString(), "\u8def\u5f84\u5206\u5272\u6570\u8d85\u8fc7" + this.size);
                }
                this.indexs[this.size++] = string.length();
            }
        }

        public void cleanup() {
            this.size = 0;
            this.string = null;
        }

        public int size() {
            return this.size - 1;
        }

        public CharSequence slice(int index) throws IndexOutOfBoundsException {
            if (index < 0 || index + 2 > this.size) {
                throw new IndexOutOfBoundsException(String.valueOf(index) + " over 0~" + (this.size - 2));
            }
            return StringUtil.subSequence(this.string, this.indexs[index] + 1, this.indexs[index + 1]);
        }
    }
}

