/*
 * Decompiled with CFR 0.152.
 */
package cn.weforward.common.util;

import cn.weforward.common.Destroyable;
import cn.weforward.common.DestroyableExt;
import cn.weforward.common.Nameable;
import cn.weforward.common.crypto.Hex;
import cn.weforward.common.execption.AbortTaskExecute;
import cn.weforward.common.sys.Shutdown;
import cn.weforward.common.sys.Timepoint;
import cn.weforward.common.util.TaskExecutor;
import cn.weforward.common.util.ThreadPool;
import java.util.ArrayList;
import java.util.Date;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BackgroundExecutor
implements TaskExecutor,
DestroyableExt {
    public static final Logger _Logger = LoggerFactory.getLogger(TaskExecutor.class);
    static final RejectedExecutionHandler _ExecutionHandler = new ThreadPoolExecutor.AbortPolicy();
    static final Timer _Timer = new Timer("bgTimer-share", true);
    static final Timer _Dead = new Timer("bgTimer-Dead", true);
    protected Timer m_Timer;
    protected final ThreadLocal<Object> m_Mark = new ThreadLocal();
    protected final ArrayList<TaskImpl> m_Tasks = new ArrayList();
    protected Executor m_Executor;
    protected String m_Name;
    protected volatile int m_CreateTimes;

    public BackgroundExecutor(Executor executor) {
        this.m_Executor = executor;
        this.m_Timer = _Timer;
        Shutdown.register(this);
        if (executor instanceof Nameable) {
            this.m_Name = ((Nameable)((Object)executor)).getName();
        }
    }

    public BackgroundExecutor(int maxThreads, String name) {
        this(new ThreadPool(maxThreads, name));
        ThreadPool tp = (ThreadPool)this.m_Executor;
        tp.setDaemon(true);
        tp.setIdle(1800);
    }

    public BackgroundExecutor(int minThreads, int maxThreads, int queueSize) {
        this(null);
        ThreadPoolExecutor threadPool = new ThreadPoolExecutor(minThreads, maxThreads, 2L, TimeUnit.MINUTES, new ArrayBlockingQueue<Runnable>(queueSize), new ThreadFactory(){

            @Override
            public Thread newThread(Runnable r) {
                StringBuilder sb;
                String name = BackgroundExecutor.this.getName();
                if (name == null || name.length() == 0) {
                    sb = new StringBuilder(12);
                    sb.append("bgt-");
                } else {
                    sb = new StringBuilder(9 + name.length());
                    sb.append(name).append('-');
                }
                sb.append(++BackgroundExecutor.this.m_CreateTimes);
                name = sb.toString();
                Thread t = new Thread(r, name);
                if (t.isDaemon()) {
                    t.setDaemon(false);
                }
                return t;
            }
        }, _ExecutionHandler);
        threadPool.allowCoreThreadTimeOut(true);
        this.m_Executor = threadPool;
    }

    protected Timer getTimer(boolean restart) {
        Timer timer = this.m_Timer;
        if (_Dead == timer) {
            return timer;
        }
        if (timer == null || restart) {
            _Logger.error("\u91cd\u5efaTimer\uff1a" + this);
            this.m_Timer = timer = new Timer("bgTimer-" + Hex.toHex(this.hashCode()), true);
        }
        return timer;
    }

    public void setName(String name) {
        this.m_Name = name;
    }

    public String getName() {
        return this.m_Name;
    }

    public String toString() {
        return this.toString(new StringBuilder(64)).toString();
    }

    public StringBuilder toString(StringBuilder sb) {
        sb.append("{name:");
        if (this.m_Name == null || this.m_Name.length() == 0) {
            Hex.toHex(this.hashCode(), sb);
        } else {
            sb.append(this.m_Name);
        }
        sb.append(",tasks:").append(this.m_Tasks.size());
        if (this.m_Executor instanceof ExecutorService) {
            ThreadPoolExecutor tpe = (ThreadPoolExecutor)this.m_Executor;
            sb.append(",core:").append(tpe.getCorePoolSize()).append(",max:").append(tpe.getMaximumPoolSize()).append(",active:").append(tpe.getActiveCount()).append(",done:").append(tpe.getCompletedTaskCount());
        } else {
            sb.append(",pool:").append(this.m_Executor);
        }
        sb.append(",timer:");
        if (_Timer == this.m_Timer) {
            sb.append("share");
        } else if (_Dead == this.m_Timer) {
            sb.append("dead");
        } else {
            sb.append(this.m_Timer);
        }
        sb.append("}");
        return sb;
    }

    @Override
    public synchronized TaskExecutor.Task execute(Runnable worker, int options, long delay, long period) {
        if (this.isShutdown()) {
            throw new RejectedExecutionException("\u6267\u884c\u5668\u5df2\u505c:" + this.getName());
        }
        TaskImpl tx = new TaskImpl(worker, options);
        if (worker instanceof TaskExecutor.AbstractWorker) {
            ((TaskExecutor.AbstractWorker)worker).setTask(tx);
        }
        if (period > 0L || delay > 0L) {
            TimerTaskExt t = new TimerTaskExt(tx);
            if (period > 0L) {
                Timer timer = this.getTimer(false);
                try {
                    timer.schedule((TimerTask)t, delay < 0L ? 0L : delay, period);
                }
                catch (IllegalStateException e) {
                    _Logger.error("\u5b9a\u65f6\u5668\u5f02\u5e38\uff1a" + this, (Throwable)e);
                    this.getTimer(true).schedule((TimerTask)t, delay < 0L ? 0L : delay, period);
                }
            } else {
                tx.setOnce();
                Timer timer = this.getTimer(false);
                try {
                    timer.schedule((TimerTask)t, delay);
                }
                catch (IllegalStateException e) {
                    _Logger.error("\u5b9a\u65f6\u5668\u5f02\u5e38\uff1a" + this, (Throwable)e);
                    this.getTimer(true).schedule((TimerTask)t, delay);
                }
            }
        } else if (tx.isReady()) {
            tx.setOnce();
            this.execute(tx);
        } else {
            tx.setOnce();
            this.m_Tasks.add(tx);
        }
        return tx;
    }

    @Override
    public TaskExecutor.Task execute(Runnable worker, int options, Date firstTime, long period) {
        long delay = firstTime.getTime() - System.currentTimeMillis();
        if (0L == period && delay < 0L) {
            return null;
        }
        return this.execute(worker, options, delay, period);
    }

    @Override
    public TaskExecutor.Task execute(Runnable worker, int options, long delay) {
        return this.execute(worker, options, delay, 0L);
    }

    @Override
    public TaskExecutor.Task execute(Runnable worker, int options) {
        return this.execute(worker, options, 0L, 0L);
    }

    @Override
    public boolean isBackground() {
        return this == this.m_Mark.get();
    }

    @Override
    public void execute(Runnable runnable) {
        if (this.isShutdown()) {
            throw new RejectedExecutionException("\u6267\u884c\u5668\u5df2\u505c:" + this.getName());
        }
        if (runnable instanceof TaskExecutor.AbstractWorker) {
            TaskImpl tx = new TaskImpl(runnable, 0);
            ((TaskExecutor.AbstractWorker)runnable).setTask(tx);
        } else {
            this.m_Executor.execute(runnable);
        }
    }

    public void runTasksAtEvent(int event) {
        int i = this.m_Tasks.size() - 1;
        while (i >= 0) {
            TaskImpl task = this.m_Tasks.get(i);
            if (task.isOption(event) && task.isReady()) {
                this.m_Tasks.remove(i);
                this.execute(task);
            }
            --i;
        }
    }

    public boolean isShutdown() {
        return _Dead == this.m_Timer;
    }

    protected void shutdown() {
        Timer timer = this.m_Timer;
        this.m_Timer = _Dead;
        if (timer != null && _Timer != timer && _Dead != timer) {
            try {
                timer.cancel();
            }
            catch (Throwable e) {
                _Logger.error(e.toString(), e);
            }
        }
    }

    @Override
    public boolean destroySignal() {
        this.shutdown();
        if (this.m_Executor instanceof ExecutorService) {
            ExecutorService es = (ExecutorService)this.m_Executor;
            if (es.isTerminated()) {
                return false;
            }
            try {
                es.shutdownNow();
            }
            catch (Throwable e) {
                _Logger.error(e.toString(), e);
            }
            return true;
        }
        if (this.m_Executor instanceof DestroyableExt) {
            return ((DestroyableExt)((Object)this.m_Executor)).destroySignal();
        }
        return false;
    }

    @Override
    public void destroy() {
        this.shutdown();
        if (this.m_Executor instanceof ExecutorService) {
            try {
                ((ExecutorService)this.m_Executor).shutdownNow();
            }
            catch (Throwable e) {
                _Logger.error(e.toString(), e);
            }
        } else if (this.m_Executor instanceof Destroyable) {
            ((Destroyable)((Object)this.m_Executor)).destroy();
        }
    }

    @Override
    public boolean isReady(int options) {
        return true;
    }

    public class TaskImpl
    implements TaskExecutor.Task {
        final Runnable m_Worker;
        final int m_Options;
        volatile int m_State;
        volatile int m_Frequency;
        volatile long m_LastFinish;
        static final int STATE_RUNNING = 1;
        static final int STATE_CANCEL = 2;
        static final int STATE_FINISH = 4;
        static final int STATE_ONCE = 16;

        TaskImpl(Runnable task, int options) {
            this.m_Worker = task;
            this.m_Options = options;
            this.m_LastFinish = -1L;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            TaskImpl taskImpl = this;
            synchronized (taskImpl) {
                if (1 == (1 & this.m_State)) {
                    return;
                }
                this.m_State |= 1;
            }
            ++this.m_Frequency;
            BackgroundExecutor.this.m_Mark.set(BackgroundExecutor.this);
            try {
                this.m_Worker.run();
            }
            catch (AbortTaskExecute e) {
                this.finish();
                _Logger.error("\u7ed3\u675f\u8fd0\u884c " + this, (Throwable)e);
            }
            catch (Throwable e) {
                _Logger.error(e.getMessage(), e);
            }
            this.m_LastFinish = System.currentTimeMillis();
            BackgroundExecutor.this.m_Mark.set(null);
            taskImpl = this;
            synchronized (taskImpl) {
                this.m_State &= 0xFFFFFFFE;
                if (16 == (this.m_State & 0x10)) {
                    this.finish();
                }
            }
        }

        public boolean isOption(int option) {
            return option == (option & this.m_Options);
        }

        @Override
        public boolean isReady() {
            return BackgroundExecutor.this.isReady(this.m_Options);
        }

        @Override
        public boolean isCancel() {
            return 2 == (2 & this.m_State);
        }

        @Override
        public boolean isRunning() {
            return 1 == (1 & this.m_State);
        }

        @Override
        public synchronized void cancel() {
            this.m_State |= 2;
        }

        @Override
        public int getFrequency() {
            return this.m_Frequency;
        }

        @Override
        public Date getLastFinish() {
            return -1L == this.m_LastFinish ? null : new Date(this.m_LastFinish);
        }

        @Override
        public boolean isFinish() {
            return 4 == (4 & this.m_State);
        }

        @Override
        public synchronized void finish() {
            this.m_State |= 4;
        }

        public boolean isContinue() {
            return (6 & this.m_State) == 0 && !BackgroundExecutor.this.isShutdown();
        }

        public void setOnce() {
            this.m_State |= 0x10;
        }

        public boolean isOnce() {
            return 16 == (this.m_State & 0x10);
        }

        public String toString() {
            StringBuilder sb = new StringBuilder(160);
            sb.append("{worker:").append(this.m_Worker).append(",fre:").append(this.m_Frequency).append(",last:");
            Timepoint.formatTimestamp(this.m_LastFinish, sb);
            sb.append(",ops:").append(this.m_Options).append(",state:").append(this.m_State).append(",pool:");
            BackgroundExecutor.this.toString(sb);
            sb.append("}");
            return sb.toString();
        }
    }

    class TimerTaskExt
    extends TimerTask {
        final TaskImpl m_Tx;

        public TimerTaskExt(TaskImpl tx) {
            this.m_Tx = tx;
        }

        @Override
        public void run() {
            block10: {
                try {
                    try {
                        if (!this.m_Tx.isContinue()) {
                            this.cancel();
                            _Logger.info("\u4efb\u52a1\u5df2\u7ed3\u675f " + this.m_Tx);
                            return;
                        }
                        if (this.m_Tx.isReady()) {
                            BackgroundExecutor.this.execute(this.m_Tx);
                        }
                    }
                    catch (RejectedExecutionException e) {
                        if (BackgroundExecutor.this.isShutdown()) {
                            this.cancel();
                            _Logger.warn("\u7ebf\u7a0b\u6c60\u5df2\u5173\uff08\u7565\u8fc7\u6267\u884c\uff09 " + this.m_Tx);
                            return;
                        }
                        if (this.m_Tx.isOnce()) {
                            try {
                                _Logger.error("\u7ebf\u7a0b\u6c60\u5fd9\uff085\u79d2\u518d\u8bd5\uff09 " + this.m_Tx, (Throwable)e);
                                TimerTaskExt t = new TimerTaskExt(this.m_Tx);
                                BackgroundExecutor.this.getTimer(false).schedule((TimerTask)t, 5000L);
                            }
                            catch (IllegalStateException ee) {
                                _Logger.error("\u5b9a\u65f6\u5668\u5f02\u5e38\uff08\u7565\u8fc7\u6267\u884c\uff09 " + this.m_Tx, (Throwable)ee);
                            }
                            break block10;
                        }
                        _Logger.error("\u7ebf\u7a0b\u6c60\u5fd9\uff08\u7b49\u4e0b\u5468\u671f\uff09 " + this.m_Tx, (Throwable)e);
                    }
                }
                catch (Throwable e) {
                    _Logger.error(e.getMessage(), e);
                }
            }
        }
    }
}

