/*
 * Decompiled with CFR 0.152.
 */
package cn.weforward.common.util;

import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;

public class BatchAddLicense {
    public static void main(String[] args) throws IOException {
        String dir = args != null && args.length > 0 ? args[0] : System.getProperty("user.dir");
        String licensePath = String.valueOf(dir) + File.separator + "LICENSE";
        String projectPath = String.valueOf(dir) + File.separator + "src";
        File license = new File(licensePath);
        if (!license.exists() || !license.isFile()) {
            System.out.println("licensePath\u4e0d\u5b58\u5728");
            return;
        }
        File project = new File(projectPath);
        if (!project.exists()) {
            System.out.println("projectPath\u4e0d\u5b58\u5728");
            return;
        }
        String lineSeparator = System.getProperty("line.separator");
        StringBuilder sb = new StringBuilder();
        sb.append("/**");
        Throwable throwable = null;
        Object var9_10 = null;
        try (BufferedReader in = new BufferedReader(new InputStreamReader(new FileInputStream(license)));){
            String line;
            while ((line = in.readLine()) != null) {
                sb.append(lineSeparator);
                sb.append(" * ");
                sb.append(line);
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        sb.append(lineSeparator);
        sb.append(" * ");
        sb.append(lineSeparator);
        sb.append(" */");
        sb.append(lineSeparator);
        byte[] licenseContent = sb.toString().getBytes();
        BatchAddLicense.paddingLicense(project, licenseContent);
    }

    private static void paddingLicense(File project, byte[] licenseContent) throws IOException {
        if (project.isDirectory()) {
            File[] fileArray = project.listFiles();
            int n = fileArray.length;
            int n2 = 0;
            while (n2 < n) {
                File child = fileArray[n2];
                BatchAddLicense.paddingLicense(child, licenseContent);
                ++n2;
            }
        } else if (project.getName().endsWith(".java")) {
            ByteArrayOutputStream bytes = new ByteArrayOutputStream();
            boolean first = true;
            Throwable throwable = null;
            Object var5_3 = null;
            try (FileInputStream in = new FileInputStream(project);){
                byte[] bs = new byte[1024];
                int l = 0;
                while (-1 != (l = ((InputStream)in).read(bs))) {
                    if (first) {
                        if (new String(bs, 0, l).toString().startsWith("/**")) {
                            return;
                        }
                        first = false;
                    }
                    bytes.write(bs, 0, l);
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            throwable = null;
            var5_3 = null;
            try (FileOutputStream out = new FileOutputStream(project);){
                ((OutputStream)out).write(licenseContent);
                ((OutputStream)out).write(bytes.toByteArray());
            }
            catch (Throwable throwable3) {
                if (throwable == null) {
                    throwable = throwable3;
                } else if (throwable != throwable3) {
                    throwable.addSuppressed(throwable3);
                }
                throw throwable;
            }
        }
    }
}

