/*
 * Decompiled with CFR 0.152.
 */
package cn.weforward.common.util;

import cn.weforward.common.GcCleanable;
import cn.weforward.common.sys.GcCleaner;
import cn.weforward.common.util.NumberUtil;
import cn.weforward.common.util.RingBuffer;
import java.util.Arrays;

public class Bytes {
    protected final byte[] m_Bytes;
    protected int m_Offset;
    protected int m_Size;
    public static final byte[] _nilBytes = new byte[0];
    static final Bytes _nil = new Bytes(_nilBytes);
    public static final long UNIT_TB = 0x10000000000L;
    public static final int UNIT_GB = 0x40000000;
    public static final int UNIT_MB = 0x100000;
    public static final int UNIT_KB = 1024;
    public static final int REMAIN_XB = 102;
    public static int POOL_8K_SIZE = NumberUtil.toInt(System.getProperty("Bytes.POOL_8K_SIZE"), 512);
    public static int POOL_1K_SIZE = NumberUtil.toInt(System.getProperty("Bytes.POOL_1K_SIZE"), 1024);
    public static int POOL_512_SIZE = NumberUtil.toInt(System.getProperty("Bytes.POOL_512_SIZE"), 2048);

    public Bytes(byte[] bytes, int offset, int size) {
        if (offset < 0 || offset + size > bytes.length) {
            throw new IllegalArgumentException("offset[" + offset + "]+size[" + size + "] over{0~" + bytes.length + "}");
        }
        if (size < 0 || size > offset + bytes.length) {
            throw new IllegalArgumentException("size[" + size + "+" + offset + "] over{0~" + bytes.length + "}");
        }
        this.m_Bytes = bytes;
        this.m_Offset = offset;
        this.m_Size = size;
    }

    public Bytes(byte[] bytes) {
        this.m_Bytes = bytes;
        this.m_Offset = 0;
        this.m_Size = bytes.length;
    }

    public byte[] getBytes() {
        return this.m_Bytes;
    }

    public int getOffset() {
        return this.m_Offset;
    }

    public int getSize() {
        return this.m_Size;
    }

    public byte[] fit() {
        if (this.m_Offset == 0 && this.m_Size == this.m_Bytes.length) {
            return this.m_Bytes;
        }
        return Arrays.copyOfRange(this.m_Bytes, this.m_Offset, this.m_Size + this.m_Offset);
    }

    public int getFree() {
        return this.m_Bytes.length - this.m_Size;
    }

    public void setSize(int size) {
        if (size < 0 || size + this.m_Offset > this.m_Bytes.length) {
            throw new IndexOutOfBoundsException("size[" + size + "]\u8d8a\u754c " + this);
        }
        this.m_Size = size;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(256);
        sb.append("{offset:").append(this.m_Offset).append(",size:").append(this.m_Size).append(",free:").append(this.getFree()).append(",bytes:");
        Bytes.toString(sb, this.m_Bytes, 50);
        sb.append("}");
        return sb.toString();
    }

    public static StringBuilder toString(StringBuilder sb, byte[] bytes, int limit) {
        if (bytes == null) {
            return null;
        }
        int count = bytes.length - 1;
        if (count == -1) {
            if (sb == null) {
                sb = new StringBuilder(2);
            }
            sb.append("[]");
            return sb;
        }
        if (limit > 0 && limit < count) {
            count = limit;
        }
        if (sb == null) {
            sb = new StringBuilder(3 * count);
        }
        sb.append('[');
        int i = 0;
        while (true) {
            sb.append(bytes[i]);
            if (i == count) break;
            sb.append(',');
            ++i;
        }
        sb.append(']').toString();
        return sb;
    }

    public static Bytes empty() {
        return _nil;
    }

    public static int compare(byte[] b1, int offset1, byte[] b2, int offset2, int length) {
        int ret = 0;
        while (length-- > 0 && ret == 0) {
            ret = b1[offset1++] - b2[offset2++];
        }
        return ret;
    }

    public static String formatHumanReadable(long bytes) {
        return Bytes.formatHumanReadable(new StringBuilder(8), bytes).toString();
    }

    public static StringBuilder formatHumanReadable(StringBuilder sb, long bytes) {
        if (bytes > 0x10000000000L) {
            sb.append(bytes / 0x10000000000L);
            int remain = (int)(bytes % 0x10000000000L / 0x40000000L);
            if (remain > 102) {
                sb.append('.').append(remain /= 102);
            }
            sb.append("T");
        } else if (bytes > 0x40000000L) {
            sb.append(bytes / 0x40000000L);
            int remain = (int)(bytes % 0x40000000L / 0x100000L);
            if (remain > 102) {
                sb.append('.').append(remain /= 102);
            }
            sb.append("G");
        } else if (bytes > 0x100000L) {
            sb.append(bytes / 0x100000L);
            int remain = (int)(bytes % 0x100000L / 1024L);
            if (remain > 102) {
                sb.append('.').append(remain /= 102);
            }
            sb.append("M");
        } else if (bytes > 1024L) {
            sb.append(bytes / 1024L);
            int remain = (int)(bytes % 1024L);
            if (remain > 102) {
                sb.append('.').append(remain /= 102);
            }
            sb.append("K");
        } else {
            sb.append(bytes);
        }
        return sb;
    }

    public static long parseHumanReadable(String readable) throws NumberFormatException {
        long unit;
        if (readable == null || readable.length() == 0) {
            return 0L;
        }
        char last = readable.charAt(readable.length() - 1);
        if (NumberUtil.isNumber(last)) {
            return Long.parseLong(readable);
        }
        switch (last) {
            case 'B': 
            case 'b': {
                unit = 1L;
                break;
            }
            case 'K': 
            case 'k': {
                unit = 1024L;
                break;
            }
            case 'M': 
            case 'm': {
                unit = 0x100000L;
                break;
            }
            case 'G': 
            case 'g': {
                unit = 0x40000000L;
                break;
            }
            case 'T': 
            case 't': {
                unit = 0x10000000000L;
                break;
            }
            default: {
                throw new NumberFormatException("\u65e0\u6cd5\u89e3\u6790:" + readable);
            }
        }
        readable = readable.substring(0, readable.length() - 1);
        if (readable.contains(".")) {
            return (long)(Double.parseDouble(readable) * (double)unit);
        }
        return Long.parseLong(readable) * unit;
    }

    public static Pool pool(int capacity) {
        if (capacity <= Pool._512.capacity()) {
            return Pool._512;
        }
        if (capacity <= Pool._1k.capacity()) {
            return Pool._1k;
        }
        if (capacity <= Pool._8k.capacity()) {
            return Pool._8k;
        }
        return null;
    }

    public static class Pool
    extends RingBuffer<byte[]> {
        protected int m_Capacity;
        public static Pool _8k = new Pool(POOL_8K_SIZE, 8192);
        public static Pool _1k = new Pool(POOL_1K_SIZE, 1024);
        public static Pool _512 = new Pool(POOL_512_SIZE, 512);
        static Cleaner _Cleaner = new Cleaner();

        public Pool(int size, int capacity) {
            super(size);
            this.m_Capacity = capacity;
        }

        public int capacity() {
            return this.m_Capacity;
        }

        @Override
        protected byte[] onEmpty() {
            return new byte[this.capacity()];
        }

        @Override
        public boolean offer(byte[] item) {
            if (item == null || item.length != this.capacity()) {
                return false;
            }
            return super.offer(item);
        }

        static class Cleaner
        implements GcCleanable {
            Cleaner() {
                GcCleaner.register(this);
            }

            @Override
            public void onGcCleanup(int policy) {
                _8k.onGcCleanup(policy);
                _1k.onGcCleanup(policy);
                _512.onGcCleanup(policy);
            }
        }
    }
}

