/*
 * Decompiled with CFR 0.152.
 */
package cn.weforward.common.util;

public class CRC16 {
    CRC16Mode m_Mode;
    int m_Digest;

    public CRC16(CRC16Mode mode) {
        this.m_Mode = mode;
        this.m_Digest = mode.init;
    }

    public void update(byte[] data) {
        this.m_Digest = this.m_Mode.reverse ? CRC16.calculateReverse(this.m_Digest, this.m_Mode.polynomial, data) : CRC16.calculate(this.m_Digest, this.m_Mode.polynomial, data);
    }

    public short digest() {
        return (short)(this.m_Digest ^ this.m_Mode.finalXor);
    }

    public static short calculate(CRC16Mode mode, byte[] data) {
        int value = mode.reverse ? CRC16.calculateReverse(mode.init, mode.polynomial, data) : CRC16.calculate(mode.init, mode.polynomial, data);
        return (short)(value ^ mode.finalXor);
    }

    private static int calculate(int init, int polynomial, byte[] data) {
        int i = 0;
        while (i < data.length) {
            init ^= (data[i] & 0xFF) << 8;
            int j = 0;
            while (j < 8) {
                int flag = init & 0x8000;
                init <<= 1;
                if (flag != 0) {
                    init ^= polynomial;
                }
                ++j;
            }
            ++i;
        }
        return init;
    }

    private static int calculateReverse(int init, int polynomial, byte[] data) {
        int i = 0;
        while (i < data.length) {
            init ^= data[i] & 0xFF;
            int j = 0;
            while (j < 8) {
                int flag = init & 1;
                init >>= 1;
                if (flag == 1) {
                    init ^= polynomial;
                }
                ++j;
            }
            ++i;
        }
        return init;
    }

    public static enum CRC16Mode {
        CCITT_FALSE(65535, 4129, 0, false),
        CCITT(0, 33800, 0, true),
        XMODEM(0, 4129, 0, false),
        X25(65535, 33800, 65535, true),
        MODBUS(65535, 40961, 0, true),
        MAXIM(0, 40961, 65535, true),
        IBM(0, 40961, 0, true),
        USB(65535, 40961, 65535, true);

        public final int init;
        public final int polynomial;
        public final int finalXor;
        public final boolean reverse;

        private CRC16Mode(int init, int polynomial, int finalXor, boolean reverse) {
            this.init = init;
            this.polynomial = polynomial;
            this.finalXor = finalXor;
            this.reverse = reverse;
        }
    }
}

